% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Error.R
\docType{class}
\name{Error}
\alias{Error}
\title{Error Class}
\format{
An [`R6::R6Class`] generator for `Error` objects.
}
\description{
An `Error` object tracks and reports errors that occur during request
handling or middleware execution in a [`Router`].
Errors are collected in a list, and the `occurred` active binding indicates
whether any errors have been set.
}
\seealso{
[Middleware], [Router], [handleErrors]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{errors}}{Character vector of recorded error messages.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{occurred}}{Logical; `TRUE` if any errors have been recorded.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Error-set}{\code{Error$set()}}
\item \href{#method-Error-clone}{\code{Error$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Error-set"></a>}}
\if{latex}{\out{\hypertarget{method-Error-set}{}}}
\subsection{Method \code{set()}}{
Append an error message to `errors`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Error$set(err)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{err}}{Error message (coerced to character).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Error-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Error-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Error$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
