% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_zOutlookRiskAdjustmentBCL.R
\name{zOutlookRiskAdjustmentBCL}
\alias{zOutlookRiskAdjustmentBCL}
\title{Calculates per share Profit and Loss at expiration for Bear Call Ladder and draws its graph in the Plots tab.}
\usage{
zOutlookRiskAdjustmentBCL(
  ST,
  X1L,
  X2M,
  X3H,
  CX1L,
  CX2M,
  CX3H,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Profit / Loss [PnL] at Expiration ($)",
  main = "Bear Call Ladder [ PnL ]"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{X2M}{Medium Strike Price or eXercise price.}

\item{X3H}{Higher Strike Price or eXercise price.}

\item{CX1L}{Call Premium received for the sold Call at Lower Strike.}

\item{CX2M}{Call Premium paid for the bought Call at Medium Strike.}

\item{CX3H}{Call Premium paid for the bought Call at higher Strike .}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
This is a vertical spread consisting of a short position in (usually) a close to ATM (at-the-money) call option with a strike price X1L, a long position in an OTM (out-of-the-money) call option with a strike price X2M, and a long position in another OTM call option with a higher strike price X3H. A bear call ladder typically arises when a bear call spread (a bearish strategy) goes wrong (the stock trades higher), so the trader buys another OTM call option (with the strike price X1L) to reverse from the initial bearish outlook to emerging bullish trends. On initiation, this is a net credit Strategy and results in net cash inflow as premium received on shorting a call (at lower strike) is more than premium paid on buying two calls (buying one call at somewhat middle priced strike X2M and then buying one more call at higher strike X3H) (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Bear Call Ladder and draw its graph in the Plots tab. EXAMPLE, Shorting  HypoFintech December 24 put at $2.40, buying HypoFintech December 21 put at $1.00, and then again buying HypoFintech December 19 put at $0.40. This is used when Bear call Spread goes wrong and the Trader is trying to Adjust Initial Bearish outlook to now a Bullish. The graph gets displayed in Plots tab.
}
\examples{
zOutlookRiskAdjustmentBCL(19,19,20,24,4.20,2.40,0.80)
zOutlookRiskAdjustmentBCL(200,200,201,204,7,4,2,hl=0.95,hu=1.1)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
