% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rejoin.R
\name{rejoin}
\alias{rejoin}
\title{Join data and metadata}
\usage{
rejoin(x)
}
\arguments{
\item{x}{\link{behavr} object}
}
\value{
a \link[data.table:data.table]{data.table::data.table}
}
\description{
This function joins the data of a \link{behavr} table to its own metadata.
When dealing with large data sets, it is preferable to keep metadata and data separate
until a summary of data is computed.
Indeed, joining many metavariables to
very long time series may result in unnecessary -- and prohibitively -- large memory footprint.
}
\examples{
set.seed(1)
met <- data.table::data.table(id = 1:5,
                              condition = letters[1:5],
                              sex = c("M", "M", "M", "F", "F"),
                              key = "id")
data <- met[,
             list(t = 1L:100L,
                  x = rnorm(100),
                  y = rnorm(100),
                  eating = runif(100) > .5 ),
             by = "id"]

d <- behavr(data, met)
summary_d <- d[, .(test = mean(x)), by = id]
rejoin(summary_d)
}
\seealso{
\itemize{
\item \link{behavr} -- to formally create a behavr object
}
}
