% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmv.R
\name{xmv}
\alias{xmv}
\title{Expand a metavariable and map it against the data}
\usage{
xmv(var)
}
\arguments{
\item{var}{the name of the variable to be extracted}
}
\value{
a vector of the same type as \code{var}, but of the same length as the number of row in the parent data.
Each row of data is matched against metadata for this specific variable.
}
\description{
This function eXpands a MetaVariable from a parent \link{behavr} object.
That is, it matches this variable (from metadata) to the data \emph{by id}.
}
\details{
This function \emph{can only be called within between the \verb{[]} of a parent} \link{behavr} object.
It is intended to facilitate operations between data and metadata.
For instance, when one wants to modify a variable according to a metavariable.
}
\examples{
#### First, we create some data

library(data.table)
set.seed(1)
data <- data.table(
                   id = rep(c("A", "B"), times = c(10, 26)),
                   t = c(1:10, 5:30),
                   x = rnorm(36), key = "id"
                   )

metadata = data.table(id = c("A", "B"),
                      treatment = c("w", "z"),
                      lifespan = c(19, 32),
                      ref_x = c(1, 0),
                      key = "id")
dt <- behavr(data, metadata)
summary(dt)

#### Subsetting using metadata

dt[xmv(treatment) == "w"]
dt[xmv(treatment) == "w"]
dt[xmv(lifespan) < 30]

#### Allocating new columns using metavariable

# Just joining lifespan (not necessary)
dt[, lif := xmv(lifespan)]
print(dt)
# Anonymously (more useful)
dt[, x2 := x - xmv(ref_x)]
print(dt)
}
\seealso{
\itemize{
\item \link{behavr} -- to formally create a behavr object
\item \link{rejoin} -- to join all metadata with data
}
}
