% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learnVocab.R
\name{learnVocab}
\alias{learnVocab}
\title{spaced learning}
\usage{
learnVocab(vocfile = "C:/Dropbox/Sonstiges/Vokabeln.csv", nnew = 3)
}
\arguments{
\item{vocfile}{File with vocabulary (or whatever you want to learn).
The first line must contain the learning day, see examples.
The second line must contain LEVEL;known;new, the last two being
(short) names, e.g. languages (known will be displayed first).}

\item{nnew}{Number of new entries to be added interactively at the start.
They can still be skipped by writing nothing and pressing the ENTER key.
DEFAULT: 3}
}
\value{
Updated vocab list, invisibly.
}
\description{
spaced learning e.g. for vocabulary. Uses interactive questions.\cr
Note: this currently clears the console!\cr
Based on \url{https://ncase.me/remember/} by Nicky Case.\cr
At the beginning, new vocab will be asked, skip with empty ENTER.
}
\examples{
\dontrun{ # Excluded from checks, works only interactively! 
# initiate empty vocab list:
vocfile <- tempfile("myvocab",fileext=".csv")
cat("learning_day 1\nLEVEL;DE;FR\n1;Das Haus;la maison\n", file=vocfile)

learnVocab(vocfile) # asks new vocab, then tests and changes level as needed
}

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2019
}
\keyword{file}
