% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_keys.R
\name{detect_keys}
\alias{detect_keys}
\alias{detect_keys.character}
\alias{detect_keys,character-method}
\alias{detect_keys.rmd_doc}
\alias{detect_keys,rmd_doc-method}
\title{Detect bibtexkeys used in an r-markdown document}
\usage{
detect_keys(x, ...)

\method{detect_keys}{character}(x, ...)

\method{detect_keys}{rmd_doc}(x, ...)
}
\arguments{
\item{x}{A character vector, a file imported by \code{\link[=readLines]{readLines()}} or an object
imported by \code{\link[yamlme:read_rmd]{yamlme::read_rmd()}}. If the character vector is the name of a Rmd
or a Quarto document, \code{\link[=readLines]{readLines()}} will be internally called to read it.}

\item{...}{Further arguments passed among methods. In character-method they
are passed to \code{\link[=readLines]{readLines()}}.}
}
\value{
A data frame with two columns, \code{bibtexkey} for the found keys and \code{line}
with the line number of the occurrence of the key in the document.
}
\description{
This function screens a character vector (usually an imported r-markdown
document) for the use of citations by bibtexkeys (\verb{@bibtexkey}), retrieving
the detected key with its occurrence in the vector, assuming each element as
a line of the original document.

This function is based on \code{bbt_detect_citations()} from the package
\href{https://github.com/paleolimbot/rbbt}{rbbt}.
}
\examples{
## Screen for citations in installed document
cited_refs <- detect_keys(file.path(path.package("biblio"), "document.Rmd"))
cited_refs
}
