% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigPCAcpp-package.R
\docType{package}
\name{bigPCAcpp-package}
\alias{bigPCAcpp-package}
\alias{bigPCAcpp}
\title{bigPCAcpp: Principal Component Analysis for bigmemory Matrices}
\description{
The \strong{bigPCAcpp} package provides high-performance principal component analysis
routines that work directly with \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} objects. Data are
streamed through BLAS and LAPACK kernels so large, file-backed matrices can be
analysed without materialising dense copies in R. Companion helpers compute
scores, loadings, correlations, and contributions, including streaming
variants that write results to \code{bigmemory::big.matrix} destinations used by
file-based pipelines.
}
\examples{
\donttest{
library(bigmemory)
mat <- as.big.matrix(matrix(rnorm(20), nrow = 5))
result <- pca_bigmatrix(mat)
result$sdev
}
}
\seealso{
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}}, \code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}}
}
\author{
\strong{Maintainer}: Frederic Bertrand \email{frederic.bertrand@lecnam.net}

}
