% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plots.R
\name{pca_plot_scores}
\alias{pca_plot_scores}
\title{Plot sampled PCA scores}
\usage{
pca_plot_scores(
  x,
  rotation,
  center = numeric(),
  scale = numeric(),
  components = c(1L, 2L),
  max_points = 5000L,
  sample = c("uniform", "head"),
  seed = NULL,
  draw = TRUE,
  ...
)
}
\arguments{
\item{x}{Either a \code{bigmemory::big.matrix}, a standard matrix, or a data
frame.}

\item{rotation}{A rotation matrix such as \code{pca_result$rotation}.}

\item{center}{Optional centering vector. Use \code{numeric()} when no centering
was applied.}

\item{scale}{Optional scaling vector. Use \code{numeric()} when no scaling was
applied.}

\item{components}{Length-two integer vector selecting the principal
components to display.}

\item{max_points}{Maximum number of observations to sample for the plot.}

\item{sample}{Strategy for selecting rows. \code{"uniform"} draws a random sample
without replacement, whereas \code{"head"} takes the first \code{max_points} rows.}

\item{seed}{Optional seed to make the sampling reproducible.}

\item{draw}{Logical; set to \code{FALSE} to skip plotting and only return the
sampled scores.}

\item{...}{Additional graphical parameters forwarded to \code{\link[=plot]{plot()}}.}
}
\value{
A list containing \code{indices} (the sampled row indices) and \code{scores}
(the corresponding score matrix) is returned invisibly. When \code{draw = TRUE}
a scatter plot is produced.
}
\description{
Streams a subset of observations through the PCA rotation and plots their
scores on the requested components. Sampling keeps the drawn subset small so
graphics remain interpretable even when the source big matrix contains
millions of rows.
}
