% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-cox-legacy.R
\name{predict_cox_pls}
\alias{predict_cox_pls}
\alias{predict.coxgpls}
\alias{predict.coxgplsDR}
\alias{predict.coxsgpls}
\alias{predict.coxsgplsDR}
\alias{predict.coxspls_sgpls}
\alias{predict.coxDKgplsDR}
\alias{predict.coxDKsgplsDR}
\alias{predict.coxDKspls_sgplsDR}
\title{Predict survival summaries from legacy Cox-PLS fits}
\usage{
\method{predict}{coxgpls}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxgplsDR}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxsgpls}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxsgplsDR}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxspls_sgpls}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxDKgplsDR}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxDKsgplsDR}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)

\method{predict}{coxDKspls_sgplsDR}(
  object,
  newdata = NULL,
  type = c("link", "risk", "response", "components"),
  comps = NULL,
  coef = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted model returned by \code{\link[=coxgpls]{coxgpls()}}, \code{\link[=coxsgpls]{coxsgpls()}},
\code{\link[=coxspls_sgpls]{coxspls_sgpls()}}, or any of their deviance-residual/kernel counterparts
with \code{allres = TRUE}.}

\item{newdata}{Optional matrix or data frame of predictors. When \code{NULL}, the
training components stored in \code{object} are reused.}

\item{type}{Type of prediction requested: \code{"link"} for linear predictors,
\code{"risk"}/\code{"response"} for exponentiated scores, or \code{"components"} to return
latent PLS scores.}

\item{comps}{Optional integer vector specifying which latent components to
retain. Defaults to all available components.}

\item{coef}{Optional coefficient vector overriding the Cox model
coefficients stored in \code{object}.}

\item{...}{Unused arguments for future extensions.}
}
\value{
When \code{type} is \code{"components"}, a matrix of latent scores; otherwise a
numeric vector containing the requested prediction with names inherited from
the supplied data.
}
\description{
These methods extend \code{\link[stats:predict]{stats::predict()}} for Cox models fitted with the
original PLS engines exposed by \code{\link[=coxgpls]{coxgpls()}}, \code{\link[=coxsgpls]{coxsgpls()}}, and their
deviance-residual or kernel variants. They provide access to latent component
scores alongside linear predictors and risk estimates, ensuring consistent
behaviour with the newer big-memory solvers.
}
\examples{
if (requireNamespace("survival", quietly = TRUE)) {
  data(micro.censure, package = "bigPLScox")
  data(Xmicro.censure_compl_imp, package = "bigPLScox")

  X <- as.matrix(Xmicro.censure_compl_imp[1:60, 1:10])
  time <- micro.censure$survyear[1:60]
  status <- micro.censure$DC[1:60]

  set.seed(321)
  fit <- coxgpls(
    Xplan = X,
    time = time,
    status = status,
    ncomp = 2,
    allres = TRUE
  )

  predict(fit, newdata = X[1:5, ], type = "risk")
  head(predict(fit, type = "components"))
}

}
\references{
Bastien, P., Bertrand, F., Meyer, N., & Maumy-Bertrand, M. (2015).
Deviance residuals-based sparse PLS and sparse kernel PLS for censored
data. \emph{Bioinformatics}, 31(3), 397–404. \url{doi:10.1093/bioinformatics/btu660}

Bertrand, F., Bastien, P., & Maumy-Bertrand, M. (2018).
Cross validating extensions of kernel, sparse or regular partial least
squares regression models to censored data. \url{https://arxiv.org/abs/1810.01005}.
}
\seealso{
\code{\link[=coxgpls]{coxgpls()}}, \code{\link[=coxsgpls]{coxsgpls()}}, \code{\link[=coxspls_sgpls]{coxspls_sgpls()}},
\code{\link[=coxDKgplsDR]{coxDKgplsDR()}}, \code{\link[=predict.big_pls_cox]{predict.big_pls_cox()}}, \code{\link[=computeDR]{computeDR()}}.
}
