% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sim_data}
\alias{sim_data}
\title{Simulated dataset}
\format{
A data frame with 1000 observations on the following 11 variables.
\describe{
\item{status}{a binary vector}
\item{X1}{a numeric vector}
\item{X2}{a numeric vector}
\item{X3}{a numeric vector}
\item{X4}{a numeric vector}
\item{X5}{a numeric vector}
\item{X6}{a numeric vector}
\item{X7}{a numeric vector}
\item{X8}{a numeric vector}
\item{X9}{a numeric vector}
\item{X10}{a numeric vector}
}
}
\description{
This dataset provides explantory variables simulations and censoring status.
}
\examples{

\donttest{
data(sim_data)
X_sim_data_train <- sim_data[1:800,2:11]
C_sim_data_train <- sim_data$status[1:800]
X_sim_data_test <- sim_data[801:1000,2:11]
C_sim_data_test <- sim_data$status[801:1000]
rm(X_sim_data_train,C_sim_data_train,X_sim_data_test,C_sim_data_test)
}

}
\references{
Maumy, M., Bertrand, F. (2023). PLS models and their extension for big data.
Joint Statistical Meetings (JSM 2023), Toronto, ON, Canada.

Maumy, M., Bertrand, F. (2023). bigPLS: Fitting and cross-validating
PLS-based Cox models to censored big data. BioC2023 — The Bioconductor
Annual Conference, Dana-Farber Cancer Institute, Boston, MA, USA.
Poster. https://doi.org/10.7490/f1000research.1119546.1

Bastien, P., Bertrand, F., Meyer, N., and Maumy-Bertrand, M.
(2015). Deviance residuals-based sparse PLS and sparse kernel PLS for
binary classification and survival analysis. \emph{BMC Bioinformatics}, 16, 211.
}
\keyword{datasets}
