% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBM-code256.R
\name{big_counts}
\alias{big_counts}
\title{Counts for class FBM.code256}
\usage{
big_counts(
  X.code,
  ind.row = rows_along(X.code),
  ind.col = cols_along(X.code),
  byrow = FALSE
)
}
\arguments{
\item{X.code}{An object of class \link[=FBM.code256-class]{FBM.code256}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{byrow}{Count by rows rather than by columns?
Default is \code{FALSE} (count by columns).}
}
\value{
A matrix of counts of K x m (or n) elements, where
\itemize{
\item K is the number of unique elements of the \code{BM.code},
\item n is its number of rows,
\item m is its number of columns.
}

\strong{Beware that K is up to 256. So, if you apply this on a Filebacked Big
Matrix of one million columns, you will create a matrix of nearly 1GB!}
}
\description{
Counts by columns (or rows) the number of each unique element of a
\code{FBM.code256}.
}
\examples{
X <- big_attachExtdata()
class(X)  # big_counts() is available for class FBM.code256 only
X[1:5, 1:8]

# by columns
big_counts(X, ind.row = 1:5, ind.col = 1:8)

# by rows
big_counts(X, ind.row = 1:5, ind.col = 1:8, byrow = TRUE)

}
