% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca-project.R
\name{pca_OADP_proj}
\alias{pca_OADP_proj}
\alias{pca_OADP_proj2}
\title{OADP projection}
\usage{
pca_OADP_proj(X, loadings, sval)

pca_OADP_proj2(XV, X_norm, sval)
}
\arguments{
\item{X}{Data to get PC loadings into.}

\item{loadings}{PC loadings of the reference PCA to project.}

\item{sval}{Singular values of the reference PCA (sqrt of the eigen values).
Only the \code{ncol(loadings)} first ones will be used.}

\item{XV}{\code{X \%*\% loadings}}

\item{X_norm}{Vector of sums of squared rows (e.g. \code{rowSums(X^2)}).}
}
\value{
\itemize{
\item \code{pca_OADP_proj()}: A list with the simple projection \code{X \%*\% loadings}
and the projection based on OADP.
}

\itemize{
\item \code{pca_OADP_proj2()}: The projection based on OADP only
(a matrix of same size of \code{XV}).
}
}
\description{
Online Augmentation, Decomposition, and Procrustes (OADP) projection of
PC loadings onto some study data \code{X}.
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
N <- 400; M <- ncol(X)
ind <- sample(nrow(X), N)

# Compute SVD using one part of samples
svd <- svds(X[ind, ], k = 5)
U <- sweep(svd$u, 2, svd$d, '*')
col <- 2:3
plot(U[, col])
points(cbind(0, 0), pch = 8, col = "green", cex = 2)

# Projecting other samples
proj <- pca_OADP_proj(X = X[-ind, ], loadings = svd$v, sval = svd$d)
points(proj$simple_proj[, col], col = "red", pch = 20)     # shrunk towards 0
points(proj$OADP_proj[, col], col = "blue", pch = 20)      # unshrunk

}
