% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_split_plan.R
\name{make_split_plan}
\alias{make_split_plan}
\title{Create leakage-resistant splits}
\usage{
make_split_plan(
  x,
  outcome = NULL,
  mode = c("subject_grouped", "batch_blocked", "study_loocv", "time_series"),
  group = NULL,
  batch = NULL,
  study = NULL,
  time = NULL,
  v = 5,
  repeats = 1,
  stratify = FALSE,
  nested = FALSE,
  seed = 1,
  horizon = 0,
  progress = TRUE,
  compact = FALSE,
  strict = TRUE
)
}
\arguments{
\item{x}{SummarizedExperiment or data.frame/matrix (samples x features).
If SummarizedExperiment, metadata are taken from colData(x). If data.frame,
metadata are taken from x (columns referenced by \code{group}, \code{batch}, \code{study}, \code{time}, \code{outcome}).}

\item{outcome}{character, outcome column name (used for stratification).}

\item{mode}{one of "subject_grouped","batch_blocked","study_loocv","time_series".}

\item{group}{subject/group id column (for subject_grouped). Required when
mode is `subject_grouped`; use `group = "row_id"` to explicitly request
sample-wise CV.}

\item{batch}{batch/plate/center column (for batch_blocked).}

\item{study}{study id column (for study_loocv).}

\item{time}{time column (numeric or POSIXct) for time_series.}

\item{v}{integer, number of folds (k) or rolling partitions.}

\item{repeats}{integer, number of repeats (>=1) for non-LOOCV modes.}

\item{stratify}{logical, keep outcome proportions similar across folds.
For grouped modes, stratification is applied at the group level (by
majority class per group) if \code{outcome} is provided; otherwise ignored.}

\item{nested}{logical, whether to attach inner CV splits (per outer fold)
using the same \code{mode} on the outer training set (with \code{v} folds, 1 repeat).}

\item{seed}{integer seed.}

\item{horizon}{numeric (>=0), minimal time gap for time_series so that the
training set only contains samples with time < min(test_time) when horizon = 0,
and time <= min(test_time) - horizon otherwise.}

\item{progress}{logical, print progress for large jobs.}

\item{compact}{logical; store fold assignments instead of explicit train/test
indices to reduce memory usage for large datasets. Not supported when
\code{nested = TRUE}.}

\item{strict}{logical; deprecated and ignored. `subject_grouped` always
requires a non-NULL `group`.}
}
\value{
A \code{\linkS4class{LeakSplits}} S4 object containing:
  \describe{
    \item{\code{mode}}{Character string indicating the splitting mode
      (\code{"subject_grouped"}, \code{"batch_blocked"}, \code{"study_loocv"},
      or \code{"time_series"}).}
    \item{\code{indices}}{List of fold descriptors, each containing
      \code{train} (integer vector of training indices), \code{test}
      (integer vector of test indices), \code{fold} (fold number), and
      \code{repeat_id} (repeat identifier). When \code{compact = TRUE},
      indices are stored as fold assignments instead.}
    \item{\code{info}}{List of metadata including \code{outcome}, \code{v},
      \code{repeats}, \code{seed}, grouping columns (\code{group},
      \code{batch}, \code{study}, \code{time}), \code{stratify},
      \code{nested}, \code{horizon}, \code{summary} (data.frame of fold
      sizes), \code{hash} (reproducibility checksum), \code{inner}
      (nested inner splits if \code{nested = TRUE}), and \code{coldata}
      (sample metadata).}
  }
  Use the \code{show} method to print a summary, or access slots directly
  with \code{@}.
}
\description{
Generates leakage-safe cross-validation splits for common biomedical setups:
subject-grouped, batch-blocked, study leave-one-out, and time-series
rolling-origin. Supports repeats, optional stratification, nested inner CV,
and an optional prediction horizon for time series. Note that splits store
explicit indices, which can be memory-intensive for large \code{n} and many
repeats.
}
\examples{
set.seed(1)
df <- data.frame(
  subject = rep(1:10, each = 2),
  outcome = rbinom(20, 1, 0.5),
  x1 = rnorm(20),
  x2 = rnorm(20)
)
splits <- make_split_plan(df, outcome = "outcome",
                      mode = "subject_grouped", group = "subject", v = 5)
}
