% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-links.r
\name{links}
\alias{links}
\alias{link_go}
\alias{link_kegg}
\alias{link_pubmed}
\alias{link_entrez}
\alias{link_cran}
\alias{link_bioc}
\title{Construct hyperlinks to online resources}
\usage{
link_go(id, text = id, title = NULL, format = "html")

link_kegg(id, text = id, title = NULL, format = "html")

link_pubmed(id, text = id, title = NULL, format = "html")

link_entrez(id, text = id, title = NULL, format = "html")

link_cran(id, text = id, title = NULL, format = "html")

link_bioc(id, text = id, title = NULL, format = "html")
}
\arguments{
\item{id}{valid identifier for the relevant online database}

\item{text}{displayed text}

\item{title}{link title, often used in tooltips}

\item{format}{generate links using \code{"html"}, \code{"markdown"} or \code{"latex"} syntax}
}
\description{
These resource-specific functions return a hyperlink to the relevant online
database/resource based on the provided identifier (\code{id}).
}
\section{Functions}{
\itemize{
\item \code{link_go()}: to Gene Ontology Consortium

\item \code{link_kegg()}: to KEGG Pathway Database

\item \code{link_pubmed()}: to PubMed based on PMID (PubMed identifier)

\item \code{link_entrez()}: to NCBI's database for gene-specific information based
on Entrez ID

\item \code{link_cran()}: for R packages available from CRAN

\item \code{link_bioc()}: for R packages available from Bioconductor

}}
\section{Link Customization}{

By default the hyperlinked text is just the \code{id}, so
\code{link_pubmed("22066989")} becomes
\href{https://pubmed.ncbi.nlm.nih.gov/22066989}{22066989}. The \code{text} argument
allows you to customize the hyperlinked text. To display a hyperlinked URL
(e.g., \url{https://www.r-project.org}), set \code{text = NULL}.
}

\section{Data Tags}{

For a few supported online resources, specially formatted tags can be passed
to the \code{text} and \code{title} arguments to display live data obtained from the
corresponding resource. For example, \code{link_entrez("4609", text = "<symbol>")}, produces \href{https://www.ncbi.nlm.nih.gov/gene/4609}{MYC},
displaying the gene symbol rather than the Entrez ID. We could also set
\code{title = "<description>"} to produce a link that reveals the gene's
description when a user hovers over the link (using a supported browser).

Currently supported data tags:

NCBI Entrez:
\itemize{
\item \code{symbol}: Gene symbol
\item \code{description}: Gene description
\item \code{location}: Cytogenetic location
}

NCBI PubMed:
\itemize{
\item \code{title}: Article title
\item \code{year}: Publication year
\item \code{journal}: Journal title
}

Gene Ontology:
\itemize{
\item \code{name}: GO term name
\item \code{definition}: GO term definition
}
}

\examples{
link_go("GO:0005539", format = "html")
link_kegg("hsa04915", format = "html")
link_pubmed("22066989", format = "html")
link_entrez("4609", format = "html")

}
\references{
\itemize{
\item \href{https://amigo.geneontology.org/amigo}{Gene Ontology Consortium}
\item \href{https://www.kegg.jp/kegg/pathway.html}{KEGG Pathway Database}
\item \href{https://pubmed.ncbi.nlm.nih.gov}{NCBI PubMed}
\item \href{https://www.ncbi.nlm.nih.gov/gene}{NCBI Gene}
}
}
