#' Incremento corriente anual en diámetro de una especie tropical en Hawaii
#' @description
#' Tamaño del árbol, competencia, e incremento corriente anual de árboles de
#'  _Metrosideros polymorpha_ colectado en el volcán Kilauea, Hawaii.
#'   Los datos contienen 64 observaciones de incremento corriente anual
#' (definido como el incremento en `dap` en un año calendario) de cada
#' árbol. Estos incrementos fueron medidos desde el año 1986 a 1988.
#' @usage
#' data(hawaii)
#' @format Estos datos contienen las siguientes columnas:
#' \describe{
#'   \item{arb.id}{Código identificador del árbol. La primera letra del
#'   ID representa
#'   una cohorte. Hay seis cohortes que representan una cronosecuencia.}
#'   \item{dap}{Diámetro a la altura del pecho, en cm.}
#'   \item{atot}{Altura total, en m.}
#'   \item{area.copa}{Área de copa, en metros cuadrados.}
#'   \item{ind.comp}{Índice de competencia (Área basal del vecino más
#'   cercano dividido por la distancia al vecino más cercano al cuadrado
#'   más el área basal del segundo vecino más cercano dividio por la
#'   distancia al segundo vecino más cercano al cuadrado)}
#'   \item{ica.1986}{Incremento corriente anual durante el año 1986, en mm.}
#'   \item{ica.1987}{Incremento corriente anual durante el año 1987, en mm.}
#'   \item{ica.1988}{Incremento corriente anual durante el año 1988, en mm.}
#'  }
#' @source
#' Los datos fueron obtenidos desde Gerrish and Mueller-Dombois (1999).
#' @references
#' - Gerrish G, Mueller-Dombois D. 1999. Measuring stem growth rates for
#' determining age and cohort analysis of a tropical evergreen tree.
#' Pacific Science. 53(4): 418-429.
#' @examples
#' data(hawaii2)
#' head(hawaii2)
'hawaii2'
