% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-trlremeasu.r
\docType{data}
\name{trlremeasu}
\alias{trlremeasu}
\title{Tree-level remeasurements for a sample plot in a \emph{Pinus radiata} plantation}
\format{
Tree list data for a sample plot remeasured through time, and
having the following columns
\describe{
\item{plot.id}{Plot code.}
\item{tree}{Tree number.}
\item{x.coord}{Cartesian position in the X-axis, in m.}
\item{y.coord}{Cartesian position in the Y-axis, in m.}
\item{year}{Measurement year.}
\item{dead}{Dead identificator, \code{0} means alive, and \code{1} otherwise.}
\item{dbh}{diameter at breast-height, in cm.}
}
}
\source{
Data were retrieved from the paper cited below, where several details
might be worth reading.
}
\usage{
data(trlremeasu)
}
\description{
Temporal tree-level data from a sample plot established in a
Monterey pine (\emph{Pinus radiata}) forestry plantation in Chile.
The plot size is 1600 m\eqn{^{2}}{^2}, and the plantation was established
in 1990.
}
\examples{
data(trlremeasu)
head(trlremeasu)
df<-trlremeasu
df$fe<-10000/1600
df$garb.ha<- (pi/40000)*df$dbh^2*df$fe
gha.t<-tapply(df$garb.ha, df$year, sum)
nha.t<-tapply(df$fe, df$year, sum);
time<-as.numeric(rownames(gha.t))
plot(nha.t~time, type="b",las=1)
plot(gha.t~time, type="b",las=1)
}
\references{
\itemize{
\item Pommerening A, Trincado G, Salas-Eljatib C, Burkhart
H. 2023. Understanding and modelling the dynamics of data point
clouds of relative growth rate and plant size. Forest Ecology and
Management Volume 529:120652 \doi{10.1016/j.foreco.2022.120652}
}
}
\keyword{datasets}
