% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_FindOptimStat.R
\name{bm_FindOptimStat}
\alias{bm_FindOptimStat}
\alias{bm_CalculateStatBin}
\alias{bm_CalculateStatAbund}
\alias{get_optim_value}
\alias{bm_CalculateStatAbun}
\title{Calculate the best score according to a given evaluation method}
\usage{
bm_FindOptimStat(
  metric.eval = "TSS",
  obs,
  fit,
  nb.thresh = 100,
  threshold = NULL,
  boyce.bg.env = NULL,
  mpa.perc = 0.9,
  k = NULL
)

get_optim_value(metric.eval)

bm_CalculateStatBin(misc, metric.eval = "TSS")

bm_CalculateStatAbun(metric.eval, obs, fit, k)
}
\arguments{
\item{metric.eval}{a \code{character} corresponding to the evaluation metric to be used, must 
be either \code{AUCroc}, \code{AUCprg}, \code{TSS}, \code{KAPPA}, \code{ACCURACY}, \code{BIAS}, \code{POD}, 
\code{FAR}, \code{POFD}, \code{SR}, \code{CSI}, \code{ETS}, \code{OR}, \code{ORSS}, 
\code{BOYCE}, \code{MPA} (\emph{binary data}), 
\code{RMSE}, \code{MAE}, \code{MSE}, \code{Rsquared}, \code{Rsquared_aj}, \code{Max_error} 
(\emph{abundance / count / relative data}), 
\code{Accuracy}, \code{Recall}, \code{Precision}, \code{F1} (\emph{multiclass/ordinal data})}

\item{obs}{a \code{vector} of observed values (binary, \code{0} or \code{1})}

\item{fit}{a \code{vector} of fitted values (continuous)}

\item{nb.thresh}{an \code{integer} corresponding to the number of thresholds to be 
tested over the range of fitted values}

\item{threshold}{(\emph{optional, default} \code{NULL}) \cr 
A \code{numeric} corresponding to the threshold used to convert the given data}

\item{boyce.bg.env}{(\emph{optional, default} \code{NULL}) \cr 
A \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}}
or \code{\link[terra:rast]{SpatRaster}} object containing values of 
environmental variables (in columns or layers) extracted from the background 
(\emph{if presences are to be compared to background instead of absences or 
pseudo-absences selected for modeling})
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still supported such as 
\code{RasterStack} and \code{SpatialPointsDataFrame} objects. }}

\item{mpa.perc}{a \code{numeric} between \code{0} and \code{1} corresponding to the percentage 
of correctly classified presences for Minimal Predicted Area (see \code{ecospat.mpa()} in 
\pkg{ecospat})}

\item{k}{an \code{integer} corresponding to the number of environmental variables used in the 
model}

\item{misc}{a \code{matrix} corresponding to a contingency table}
}
\value{
A \code{1} row x \code{5} columns \code{data.frame} containing :
\itemize{
  \item \code{metric.eval} : the chosen evaluation metric
  \item \code{cutoff} : the associated cut-off used to transform the continuous values into 
  binary
  \item \code{sensitivity} : the sensibility obtained on fitted values with this threshold
  \item \code{specificity} : the specificity obtained on fitted values with this threshold
  \item \code{best.stat} : the best score obtained for the chosen evaluation metric
}
}
\description{
This internal \pkg{biomod2} function allows the user to find the threshold to 
convert continuous values into binary ones leading to the best score for a given evaluation 
metric.
}
\details{
\emph{Please refer to \href{https://www.cawcr.gov.au/projects/verification/}{CAWRC website 
("Methods for dichotomous forecasts")} to get detailed description (simple/complex metrics).} \cr
Optimal value of each method can be obtained with the \code{\link{get_optim_value}} function.

\describe{
  \item{simple}{
  \itemize{
    \item \code{POD} : Probability of detection (hit rate)
    \item \code{FAR} : False alarm ratio
    \item \code{POFD} : Probability of false detection (fall-out)
    \item \code{SR} : Success ratio
    \item \code{ACCURACY} : Accuracy (fraction correct)
    \item \code{BIAS} : Bias score (frequency bias)
  }
  }
  \item{complex}{
  \itemize{
    \item \code{AUCroc} : Area Under Curve of Relative operating characteristic
    \item \code{AUCprg} : Area Under Curve of Precision-Recall-Gain curve
    \item \code{TSS} : True skill statistic (Hanssen and Kuipers discriminant, Peirce's 
    skill score)
    \item \code{KAPPA} : Cohen's Kappa (Heidke skill score)
    \item \code{OR} : Odds Ratio
    \item \code{ORSS} : Odds ratio skill score (Yule's Q)
    \item \code{CSI} : Critical success index (threat score)
    \item \code{ETS} : Equitable threat score (Gilbert skill score)
  }
  }
  \item{presence-only}{
  \itemize{
    \item \code{BOYCE} : Boyce index
    \item \code{MPA} : Minimal predicted area (cutoff optimizing MPA to predict 90\% of 
    presences)
  }
  }
  \item{abundance / count / relative data}{
  \itemize{
    \item \code{RMSE} : Root Mean Square Error
    \item \code{MSE} : Mean Square Error
    \item \code{MAE} : Mean Absolute Error
    \item \code{Rsquared} : R squared
    \item \code{Rsquared_aj} : R squared adjusted
    \item \code{Max_error} : Maximum error
  }
  }
  \item{multiclass/ordinal data}{
  \itemize{
    \item \code{Accuracy} : Accuracy
    \item \code{Recall} : Macro average Recall
    \item \code{Precision} : Macro average Precision
    \item \code{F1} : Macro F1 score
  }
  }
}
  
Note that if a value is given to \code{threshold}, no optimization will be done, and 
only the score for this threshold will be returned.

The Boyce index returns \code{NA} values for \code{SRE} models because it can not be 
calculated with binary predictions. \cr This is also the reason why some \code{NA} values 
might appear for \code{GLM} models if they did not converge.
}
\note{
In order to break dependency loop between packages \pkg{biomod2} and \pkg{ecospat}, 
code of \code{ecospat.boyce()} and \code{ecospat.mpa()} in \pkg{ecospat})
functions have been copied within this file from version 3.2.2 (august 2022).
}
\examples{
## Generate a binary vector
vec.a <- sample(c(0, 1), 100, replace = TRUE)

## Generate a 0-1000 vector (random drawing)
vec.b <- runif(100, min = 0, max = 1000)

## Generate a 0-1000 vector (biased drawing)
BiasedDrawing <- function(x, m1 = 300, sd1 = 200, m2 = 700, sd2 = 200) {
  return(ifelse(x < 0.5, rnorm(1, m1, sd1), rnorm(1, m2, sd2)))
}
vec.c <- sapply(vec.a, BiasedDrawing)
vec.c[which(vec.c < 0)] <- 0
vec.c[which(vec.c > 1000)] <- 1000

## Find optimal threshold for a specific evaluation metric
bm_FindOptimStat(metric.eval = 'TSS', fit = vec.b, obs = vec.a)
bm_FindOptimStat(metric.eval = 'TSS', fit = vec.c, obs = vec.a, nb.thresh = 100)
bm_FindOptimStat(metric.eval = 'TSS', fit = vec.c, obs = vec.a, threshold = 280)


}
\references{
\itemize{
  \item Engler, R., Guisan, A., and Rechsteiner L. 2004. An improved approach for predicting 
  the distribution of rare and endangered species from occurrence and pseudo-absence data. 
  \emph{Journal of Applied Ecology}, \bold{41(2)}, 263-274.
  \item Hirzel, A. H., Le Lay, G., Helfer, V., Randin, C., and Guisan, A. 2006. Evaluating 
  the ability of habitat suitability models to predict species presences. \emph{Ecological 
  Modelling}, \bold{199(2)}, 142-152.
}
}
\seealso{
\code{ecospat.boyce()} and \code{ecospat.mpa()} in \pkg{ecospat}, 
\code{\link{BIOMOD_Modeling}}, \code{\link{bm_RunModelsLoop}}, 
\code{\link{BIOMOD_EnsembleModeling}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelAnalysis}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RangeSize}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secondary functions}
\keyword{auc}
\keyword{boyce}
\keyword{evaluation}
\keyword{models}
\keyword{mpa}
\keyword{options}
\keyword{tss}
