% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{reflect}
\alias{reflect}
\title{Reflect the biplot about a chosen axis}
\usage{
reflect(bp, reflect.axis = c("FALSE", "x", "y", "xy"))
}
\arguments{
\item{bp}{an object of class \code{biplot}}

\item{reflect.axis}{a character string indicating which axis about to reflect. One of \code{FALSE} (default), "\code{x}" for reflection about the x-axis, "\code{y}" for reflection about the y-axis and "\code{xy}" for reflection about both axes.}
}
\value{
An object of class \code{biplot}
}
\description{
This function provides the user with an option to reflect the biplot horizontally, vertically or diagonally.
}
\examples{
biplot(iris[,1:4],group.aes = iris[,5]) |> PCA() |> reflect("x") |> plot()
biplot(iris[,1:4],group.aes = iris[,5]) |> PCA() |> reflect("y") |> plot()
biplot(iris[,1:4],group.aes = iris[,5]) |> PCA() |> reflect("xy") |> plot()

}
