% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{predict_samples}
\alias{predict_samples}
\title{Computes prediction for a each sample.}
\usage{
predict_samples(
  family,
  fixedN,
  randomN,
  lmN,
  istate,
  duration,
  is_used,
  run_start,
  session_tmean,
  irandom,
  fixed,
  tau_ind,
  mixed_state_ind,
  history_init,
  a,
  bH,
  bF,
  sigma
)
}
\arguments{
\item{family}{int, distribution family: gamma (1), lognormal(2), or
normal (3).}

\item{fixedN}{int, number of fixed parameters (>= 0).}

\item{randomN}{int, number of random factors (>= 1).}

\item{lmN}{int, number of linear models (>= 1).}

\item{istate}{IntegerVector, zero-based perceptual state 0 or 1,
2 is mixed state.}

\item{duration}{DoubleVector, duration of a dominance phase.}

\item{is_used}{IntegerVector, whether dominance phase is used for
prediction (1) or not (0).}

\item{run_start}{IntegerVector, 1 whenever a new run starts.}

\item{session_tmean}{DoubleVector, average dominance phase duration.}

\item{irandom}{IntegerVector, zero-based index of a random effect.}

\item{fixed}{NumericMatrix, matrix with fixed effect values.}

\item{tau_ind}{NumericMatrix, matrix with samples of tau for each
random level.}

\item{mixed_state_ind}{NumericMatrix, matrix with samples of
mixed_state for each random level.}

\item{history_init}{DoubleVector, Initial values of history for a run}

\item{a}{NumericMatrix, matrix with samples of
a (intercept) for each random level.}

\item{bH}{NumericMatrix, matrix with sample of
bH for each linear model and random level.}

\item{bF}{NumericMatrix, matrix with sample of
bF for each linear model and fixed factor.}

\item{sigma}{DoubleVector, samples of sigma.}
}
\value{
NumericMatrix with predicted durations for each sample.
}
\description{
Computing prediction for each sample,
recomputing cumulative history and uses
fitted parameter values.
}
