% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-ints.R
\name{bits_to_uint}
\alias{bits_to_uint}
\alias{uint_to_bits}
\title{Convert between bits and unsigned integers}
\usage{
bits_to_uint(bits, nbits = NULL)

uint_to_bits(x, nbits)
}
\arguments{
\item{bits}{logical vector of bit values in MSB first order}

\item{nbits}{number of bits per integer. If NULL, then \code{bits} is assumed
to represent a single integer value.  If not NULL, then the number of 
values in \code{bits} must be a multiple of \code{nbits}}

\item{x}{vector of unsigned integers}
}
\value{
logical vector of bit values of vector of unsigned integers
}
\description{
Convert between bits and unsigned integers
}
\examples{
bits <- uint_to_bits(c(1, 2, 3), nbits = 3)
bits
bits_to_uint(bits, nbits = 3)
}
