% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-core.R
\name{bs_open}
\alias{bs_open}
\alias{bs_close}
\title{Open/close a bitstream}
\usage{
bs_open(con, mode, msb_first = TRUE, flush_threshold = 1024 * 8)

bs_close(bs, verbosity = 0)
}
\arguments{
\item{con}{A vector of raw values or an R connection (e.g. \code{file()}, \code{url()}, etc)}

\item{mode}{Bitstream mode set to read or write?  One of 'r', 'w', 'rb', 'wb'.}

\item{msb_first}{Should the output mode be Most Signficant Bit first?
Default: TRUE}

\item{flush_threshold}{Threshold number of bits at which the buffered data
will be automatically written to the connection. 
Default: 8192 bits (1024 bytes).  Note: Use \code{bs_flush()} to 
write out the buffer at any time. All bits are automatically written out 
when \code{bs_close()} is called.}

\item{bs}{Bistream connection object created with \code{bs_open()}}

\item{verbosity}{Verbosity level. Default: 0}
}
\value{
\code{bs_open()} returns a \code{bitstream} connection object. When the 
   connection is a raw vector and \code{mode = 'w'}, \code{bs_close()} returns 
   the final state of the raw vector; in all other cases \code{bs_close()}
   does not return a value.
}
\description{
Open/close a bitstream
}
\examples{
raw_vec <- as.raw(1:3)
bs  <- bs_open(raw_vec, 'r')
assert_bs(bs)
bs_close(bs)

}
