% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.bm_matrix.R
\name{as.array.bm_bitmap}
\alias{as.array.bm_bitmap}
\alias{as.array.bm_pixmap}
\title{Cast bitmap/pixmap objects to an array}
\usage{
\method{as.array}{bm_bitmap}(
  x,
  ...,
  first_row_is_top = TRUE,
  col = getOption("bittermelon.col", col_bitmap)
)

\method{as.array}{bm_pixmap}(x, ..., first_row_is_top = TRUE)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} object.}

\item{...}{Currently ignored.}

\item{first_row_is_top}{If \code{TRUE} the first row of the matrix will represent the top of the bitmap
(like \code{\link[grDevices:as.raster]{grDevices::as.raster()}} objects).
If \code{FALSE} the first row of the matrix will represent the bottom of the bitmap
(like \code{\link[=bm_bitmap]{bm_bitmap()}} and \code{\link[=bm_pixmap]{bm_pixmap()}} objects).}

\item{col}{Character vector of R color specifications.
First color is used for values equal to 0, second color for values equal to 1, etc.}
}
\description{
\code{as.array.bm_bitmap()} / \code{as.array.bm_pixmap()} casts \code{\link[=bm_bitmap]{bm_bitmap()}} / \code{\link[=bm_pixmap]{bm_pixmap()}} objects to an array of numeric values representing the RGBA channels.
These arrays can be used in functions such as \code{\link[png:writePNG]{png::writePNG()}}.
}
\examples{
corn <- farming_crops_16x16()$corn$portrait
a <- as.array(corn)
f <- tempfile(fileext = ".png")
png::writePNG(a, f)
}
