% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcomputation.R
\name{contrafactual_ATE}
\alias{contrafactual_ATE}
\title{Contrafactual Average Treatment Effects (ATE) for the Bivariate Hurdle Model}
\usage{
contrafactual_ATE(fit_obj, compute_intervals = TRUE, ndraws = 1200, seed = 42)
}
\arguments{
\item{fit_obj}{A list returned by \code{fit_one()} (or an equivalent
fitting function), containing at least:
\itemize{
\item \code{$fit}: a CmdStanR fit object.
\item \code{$des}: a list with design matrices
\code{X_pi_I}, \code{X_mu_I}, \code{X_pi_C}, \code{X_mu_C},
a vector \code{log_exposure50}, and an index vector \code{idx}.
}}

\item{compute_intervals}{Logical; if \code{TRUE}, returns posterior
means and 95\\% credible intervals (2.5\\% and 97.5\\% quantiles). If
\code{FALSE}, only posterior means are returned.}

\item{ndraws}{Integer; maximum number of posterior draws to use. If
\code{ndraws} exceeds the number of available draws, it is truncated.}

\item{seed}{Integer; random seed used to subsample posterior draws.}
}
\value{
A tibble with one row per effective time index (length
\code{des$idx}). If \code{compute_intervals = TRUE}, the columns are:
\itemize{
\item \code{t}: time index (from \code{des$idx}).
\item \code{ATE_I_mean}, \code{ATE_I_low}, \code{ATE_I_high}:
posterior mean and 95\\% credible interval for the ATE on \code{I}.
\item \code{ATE_C_mean}, \code{ATE_C_low}, \code{ATE_C_high}:
posterior mean and 95\\% credible interval for the ATE on \code{C}.
}
If \code{compute_intervals = FALSE}, only \code{ATE_I_mean} and
\code{ATE_C_mean} are returned (plus \code{t}).
}
\description{
Computes time-varying contrafactual Average Treatment Effects (ATE) for
both series (\code{I} and \code{C}) from a fitted bivariate hurdle
negative binomial model. For each time point and posterior draw, the
function compares the expected outcome under the observed design matrix
with a contrafactual scenario where cross-lag terms and transition
covariates are set to zero.
}
\details{
The function identifies in the design matrices:
\itemize{
\item Cross-lag terms via column names containing
\code{"zC_L"} / \code{"C_L"} (for \code{I}) and
\code{"zI_L"} / \code{"I_L"} (for \code{C}).
\item Transition covariates via column names starting with
\code{"trans_"}.
}
For each time point \code{t} and posterior draw \code{s}, the expected
value under the observed design (\eqn{E[Y \mid X]}) is contrasted with
a contrafactual design where these cross-lag and transition columns are
set to zero (\eqn{E[Y \mid X_{cf}]}). The ATE at time \code{t} is
defined as the posterior distribution of \eqn{E[Y \mid X] -
E[Y \mid X_{cf}]}, computed separately for \code{I} and \code{C}.
}
\examples{
\donttest{
if (interactive() && requireNamespace("cmdstanr", quietly = TRUE)) {
  n <- 120
  DT <- data.table::data.table(
    I = rpois(n, 5), C = rpois(n, 3),
    Regime = factor(sample(c("A","B","C"), n, TRUE)),
    trans_PS = c(rep(1,5), rep(0,n-5)),
    trans_SF = c(rep(0,60), rep(1,5), rep(0,n-65)),
    trans_FC = rep(0, n),
    log_exposure50 = log(runif(n, 40, 60))
  )
  fit_obj <- fit_one(DT, k = 1, spec = "C")
  ate_tab <- contrafactual_ATE(fit_obj, compute_intervals = TRUE)
  head(ate_tab)
}
}
}
