% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorResponseFunctions.R
\name{PredictorResponseUnivar}
\alias{PredictorResponseUnivar}
\title{Plot univariate predictor-response function on a new grid of points}
\usage{
PredictorResponseUnivar(
  fit,
  y = NULL,
  Z = NULL,
  X = NULL,
  which.z = 1:ncol(Z),
  method = "approx",
  ngrid = 50,
  q.fixed = 0.5,
  sel = NULL,
  min.plot.dist = Inf,
  center = TRUE,
  z.names = colnames(Z),
  ...
)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{which.z}{vector identifying which predictors (columns of \code{Z}) should be plotted}

\item{method}{method for obtaining posterior summaries at a vector of new points. Options are "approx" and "exact"; defaults to "approx", which is faster particularly for large datasets; see details}

\item{ngrid}{number of grid points to cover the range of each predictor (column in \code{Z})}

\item{q.fixed}{vector of quantiles at which to fix the remaining predictors in \code{Z}}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{min.plot.dist}{specifies a minimum distance that a new grid point needs to be from an observed data point in order to compute the prediction; points further than this will not be computed}

\item{center}{flag for whether to scale the exposure-response function to have mean zero}

\item{z.names}{optional vector of names for the columns of \code{z}}

\item{...}{other arguments to pass on to the prediction function}
}
\value{
a long data frame with the predictor name, predictor value, posterior mean estimate, and posterior standard deviation
}
\description{
Plot univariate predictor-response function on a new grid of points
}
\details{
For guided examples, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)
pred.resp.univar <- PredictorResponseUnivar(fit = fitkm)
}
