% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.plot.ggplot.r
\name{blandr.plot.ggplot}
\alias{blandr.plot.ggplot}
\title{Bland-Altman plotting function, using ggplot2}
\usage{
blandr.plot.ggplot(
  statistics.results,
  method1name = "Method 1",
  method2name = "Method 2",
  plotTitle = "Bland-Altman plot for comparison of 2 methods",
  ciDisplay = TRUE,
  ciShading = TRUE,
  normalLow = FALSE,
  normalHigh = FALSE,
  overlapping = FALSE,
  x.plot.mode = "means",
  y.plot.mode = "difference",
  plotProportionalBias = FALSE,
  plotProportionalBias.se = TRUE,
  assume.differences.are.normal = TRUE
)
}
\arguments{
\item{statistics.results}{A list of statistics generated by the blandr.statistics function: see the function's return list to see what variables are passed to this function}

\item{method1name}{(Optional) Plotting name for 1st method, default "Method 1"}

\item{method2name}{(Optional) Plotting name for 2nd method, default "Method 2"}

\item{plotTitle}{(Optional) Title name, default "Bland-Altman plot for comparison of 2 methods"}

\item{ciDisplay}{(Optional) TRUE/FALSE switch to plot confidence intervals for bias and limits of agreement, default is TRUE}

\item{ciShading}{(Optional) TRUE/FALSE switch to plot confidence interval shading to plot, default is TRUE}

\item{normalLow}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its lower boundary}

\item{normalHigh}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its higher boundary}

\item{overlapping}{(Optional) TRUE/FALSE switch to increase size of plotted point if multiple values using ggplot's geom_count, default=FALSE. Not currently recommend until I can tweak the graphics to make them better}

\item{x.plot.mode}{(Optional) Switch to change x-axis from being plotted by means (="means") or by either 1st method (="method1") or 2nd method (="method2"). Default is "means". Anything other than "means" will switch to default mode.}

\item{y.plot.mode}{(Optional) Switch to change y-axis from being plotted by difference (="difference") or by proportion magnitude of measurements (="proportion"). Default is "difference". Anything other than "proportional" will switch to default mode.}

\item{plotProportionalBias}{(Optional) TRUE/FALSE switch. Plots a proportional bias line. Default is FALSE.}

\item{plotProportionalBias.se}{(Optional) TRUE/FALSE switch. If proportional bias line is drawn, switch to plot standard errors. See stat_smooth for details. Default is TRUE.}

\item{assume.differences.are.normal}{(Optional, not operationally used currently) Assume the difference of means has a normal distribution. Will be used to build further analyses}
}
\value{
ba.plot Returns a ggplot data set that can then be plotted
}
\description{
Draws a Bland-Altman plot using data calculated using the other functions, using ggplot2
}
\examples{
# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Generates a ggplot
# Do note the ggplot function wasn't meant to be used on it's own
# and is generally called via the bland.altman.display.and.draw function

# Passes data to the blandr.statistics function to generate Bland-Altman statistics
statistics.results <- blandr.statistics( measurement1 , measurement2 )

# Generates a ggplot, with no optional arguments
blandr.plot.ggplot( statistics.results )

# Generates a ggplot, with title changed
blandr.plot.ggplot( statistics.results , plotTitle = "Bland-Altman example plot" )

# Generates a ggplot, with title changed, and confidence intervals off
blandr.plot.ggplot( statistics.results , plotTitle = "Bland-Altman example plot" ,
ciDisplay = FALSE , ciShading = FALSE )

}
\author{
Deepankar Datta \href{mailto:deepankar.datta@gmail.com}{deepankar.datta@gmail.com}
}
