% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setDefaultInitializeParameters.R
\name{setDefaultInitializeParameters}
\alias{setDefaultInitializeParameters}
\title{Sets the distribution parameters for initializing all parameters}
\usage{
setDefaultInitializeParameters(
  normalMean = 0,
  normalVariance = 1,
  normalCovariance = 0,
  dirichletAlpha = 1
)
}
\arguments{
\item{normalMean}{Sets the initialization distribution mean for all parameters with
normal distributions. Defaults to \code{0}.}

\item{normalVariance}{Sets the initialization distribution variance for all parameters with
normal distributions. Defaults to \code{10}.}

\item{normalCovariance}{Sets the initialization distribution covariance for all parameters with
multivariate normal distributions. Defaults to \code{0}.}

\item{dirichletAlpha}{Sets the initialization of the alpha parameters for all parameters with a categorical distribution.
Defaults to \code{1}.}
}
\value{
A list containing named values for each argument in the function.
}
\description{
All parameters are initialized with distributions using these parameters.
Used to quickly set priors for sets of parameters.
}
