% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-alleleCounter.R
\name{allele_counter}
\alias{allele_counter}
\title{Run alleleCount}
\usage{
allele_counter(
  hts_file,
  loci_file,
  ofile,
  ...,
  odir = getwd(),
  alleleCounter = NULL
)
}
\arguments{
\item{hts_file}{A string of path to sample HTS file.}

\item{loci_file}{A string of path to loci file.}

\item{ofile}{A string of path to the output file.}

\item{...}{<\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{alleleCounter} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link[=shQuote]{shQuote()}}. Details see: \code{cmd_help(alleleCounter())}.}

\item{odir}{A string of path to the output directory.}

\item{alleleCounter}{A string of path to \code{alleleCounter} command.}
}
\value{
A \code{command} object.
}
\description{
The \code{alleleCount} program primarily exists to prevent code duplication
between some other projects, specifically \code{AscatNGS} and \code{Battenberg}.
}
\seealso{
\itemize{
\item \url{https://github.com/cancerit/alleleCount}
\item \code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}/\code{\link[=cmd_conda]{cmd_conda()}}
\item \code{\link[=cmd_on_start]{cmd_on_start()}}/\code{\link[=cmd_on_exit]{cmd_on_exit()}}
\item \code{\link[=cmd_on_succeed]{cmd_on_succeed()}}/\code{\link[=cmd_on_fail]{cmd_on_fail()}}
\item \code{\link[=cmd_parallel]{cmd_parallel()}}
}

Other \code{commands}:
\code{\link{cellranger}()},
\code{\link{conda}()},
\code{\link{fastq_pair}()},
\code{\link{gistic2}()},
\code{\link{kraken2}()},
\code{\link{kraken_tools}()},
\code{\link{perl}()},
\code{\link{pyscenic}()},
\code{\link{python}()},
\code{\link{samtools}()},
\code{\link{seqkit}()},
\code{\link{trust4}()}
}
\concept{command}
