% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cis}
\alias{cis}
\title{Fictional customer data}
\format{
A \code{data.table} with 24613 records. Each row represents one record, with the following columns:
\itemize{
\item{\code{person_id} -- a unique number for each person, consisting of postcode, house number and person number,}
\item{\code{pername1} -- forename,}
\item{\code{pername2} -- surname,}
\item{\code{sex} -- gender (M/F),}
\item{\code{dob_day} -- day of birth,}
\item{\code{dob_mon} -- month of birth,}
\item{\code{dob_year} -- year of birth,}
\item{\code{enumcap} -- an address consisting of house number and street name,}
\item{\code{enumpc} -- postcode,}
\item{\code{cis_id} -- person ID with "CIS" added in front.}
}
}
\usage{
cis
}
\description{
This data set was created by Paula McLeod, Dick Heasman and Ian Forbes, ONS,
for the ESSnet DI on-the-job training course, Southampton, 25-28 January 2011.
It contains fictional observations from Customer Information System,
which is combined administrative data from the tax and benefit systems.
}
\examples{

data("cis")
head(cis)

}
\references{
McLeod, P., Heasman, D., Forbes, I. (2011). Simulated data for the ESSnet DI on-the-job training course,
Southampton, 25-28 January 2011.
\url{https://wayback.archive-it.org/12090/20231221144450/https://cros-legacy.ec.europa.eu/content/job-training_en}
}
\keyword{datasets}
