% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-logging.R
\docType{data}
\name{write_log}
\alias{write_log}
\alias{log_fatal}
\alias{log_error}
\alias{log_warn}
\alias{log_info}
\alias{log_debug}
\alias{log_trace}
\alias{as_log_level}
\alias{fatal_log_level}
\alias{error_log_level}
\alias{warn_log_level}
\alias{info_log_level}
\alias{debug_log_level}
\alias{trace_log_level}
\alias{get_log_level}
\alias{cnd_logger}
\alias{cat_logger}
\title{Logging}
\format{
An object of class \code{ordered} (inherits from \code{factor}) of length 1.

An object of class \code{ordered} (inherits from \code{factor}) of length 1.

An object of class \code{ordered} (inherits from \code{factor}) of length 1.

An object of class \code{ordered} (inherits from \code{factor}) of length 1.

An object of class \code{ordered} (inherits from \code{factor}) of length 1.

An object of class \code{ordered} (inherits from \code{factor}) of length 1.
}
\usage{
write_log(
  ...,
  level = "info",
  envir = parent.frame(),
  asis = FALSE,
  use_glue = TRUE,
  pkg = pkg_name(envir)
)

log_fatal(..., envir = parent.frame())

log_error(..., envir = parent.frame())

log_warn(..., envir = parent.frame())

log_info(..., envir = parent.frame())

log_debug(..., envir = parent.frame())

log_trace(..., envir = parent.frame())

as_log_level(level)

fatal_log_level

error_log_level

warn_log_level

info_log_level

debug_log_level

trace_log_level

get_log_level()

cnd_logger(msg, level)

cat_logger(msg, level)
}
\arguments{
\item{...}{Concatenated as \code{paste0(..., "\\n")}}

\item{level}{Logging level (possible values are "fatal", "error", "warn",
"info", "debug" and "trace"}

\item{envir}{Environment where the logging call originated from}

\item{asis}{Flag to disable re-wrapping of text to terminal width}

\item{use_glue}{Flag to disable use of glue}

\item{pkg}{Package name}

\item{msg}{Message (string)}
}
\value{
Logging function \code{write_log()}, wrappers \verb{log_*()} and loggers
provided as \code{cnd_logger()}/cat_logger() all return \code{NULL} invisibly and are
called for their side effect of emitting a message. Helpers \code{as_log_level()}
and \code{get_log_level()} return a scalar-valued ordered factor.
}
\description{
Internally used infrastructure for emitting log messages is exported, hoping
that other packages which depend on this, use it and thereby logging is
carried out consistently both in terms of presentation and output device.
All log messages are associated with an (ordered) level ("fatal", "error",
"warn", "info", "debug" or "trace") which is compared against the currently
set value (available as \code{get_log_level()}) and output is only generated if
the message level is greater or equal to the currently set value.
}
\keyword{datasets}
