% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series_table.R
\name{get_series_table}
\alias{get_series_table}
\title{Retrieve a time series from BLS API as a tibble}
\usage{
get_series_table(
  series_id,
  api_key = bls_get_key(),
  start_year = NULL,
  end_year = NULL,
  year_limit = NULL,
  parse_values = TRUE,
  ...
)
}
\arguments{
\item{series_id}{Character scalar BLS series ID}

\item{api_key}{Optional. An API key string. Defaults to the value returned by
\code{\link[=bls_get_key]{bls_get_key()}}. The preferred way to provide an API key is to use
\code{\link[=bls_set_key]{bls_set_key()}} or the \code{BLS_API_KEY} environment variable. Manually passing
the key will be deprecated in future releases.}

\item{start_year, end_year}{numeric 4-digit years. While optional, they are
strongly recommended. If one is provided, the other is mandatory. \code{end_year}
must be greater than \code{start_year}}

\item{year_limit}{optional number of years to paginate request by. If not
explicitly set, it will be set to 10 or 20 depending on if an \code{api_key} is
available}

\item{parse_values}{optional boolean. If set to \code{TRUE} (default) it will
attempt to parse the contents of \code{value} and cast numeric strings as numeric
values. If set to \code{FALSE} it will retain \code{value} as a column of strings.}

\item{...}{additional arguments to pass to \code{\link{get_series}}}
}
\value{
a tibble of observations or \code{NA} if the request had zero results.
}
\description{
Retrieve a time series from BLS API as a tibble
}
\examples{
\dontrun{
get_series_table('LNS14000001',2005,2006)
}

}
\seealso{
Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_series_request}()}
}
\concept{blsR-requests}
