% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{ltm_mcmc}
\alias{ltm_mcmc}
\title{MCMC LTM}
\usage{
ltm_mcmc(x, y, burnin = 2000, iter = 8000, K = 3,
  prior_par = create_prior_parameters())
}
\arguments{
\item{x}{data points}

\item{y}{response variable}

\item{burnin}{number of burnin iterations}

\item{iter}{number of iterations after burnin}

\item{K}{parameter K}

\item{prior_par}{List of parameters for prior distrributions.
See \code{\link[=create_prior_parameters]{create_prior_parameters()}}.}
}
\value{
matrix containing the posterior samples. Each line is one
sample after the burnin period and each column is one of the
parameters of the model. Columns are named to find the parameters
with ease.
}
\description{
Given \code{x} and \code{y} performs the MCMC optimization.
}
\examples{
# Generates 10 series, each one with 500 observations and 2 regressors.

d_sim <- ltm_sim(
  ns = 500, nk = 2, ni = 10,
  vmu = matrix(c(.5,.5), nrow = 2),
  mPhi = diag(2) * c(.99, .99),
  mSigs = c(.1,.1),
  dsig = .15,
  vd = matrix(c(.4,.4), nrow = 2),
  alpha = 0
)

# Fit model

fit_model <- ltm_mcmc(d_sim$mx, d_sim$vy, burnin = 0, iter = 2)

}
\references{
Nakajima, Jouchi, and Mike West. "Bayesian analysis of latent threshold
dynamic models." Journal of Business & Economic
Statistics 31.2 (2013): 151-164.
}
