% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_modfit.R
\name{modfit}
\alias{modfit}
\title{Model fit}
\usage{
modfit(x, index = "loo")
}
\arguments{
\item{x}{returned object}

\item{index}{Model fit indices. They can be "waic", which is the widely applicable information criterion, "loo", which is the leave-one-out cross-validation, or "chisq.df", which is the adjusted chi-square degrees of freedom ratios for each trait separately that were introduced by Drasgow et al. (1995). The default is loo. Note that chisq.df can only be computed when the sample size is large. See documentation for loo and GGUM for more details.}
}
\value{
Selected model fit statistics
}
\description{
This function provides model fit statistics.
}
\examples{
Data <- c(1,4,2,3)
Data <- matrix(Data,nrow = 2)
deli <- c(1,-1,2,1)
deli <- matrix(deli,nrow = 2)
ind <- c(1,2)
ind <- t(ind)
cova <- c(0.70, -1.25)
mod <- bmggum(GGUM.Data=Data,delindex=deli,trait=2,ind=ind,option=4,covariate=cova,iter=5,chains=1)
waic <- modfit(mod, 'waic')
}
