% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{softmax}
\alias{softmax}
\alias{softmaxinv}
\title{Softmax function and its inverse}
\usage{
softmax(eta, lambda = 1)

softmaxinv(p, lambda = 1)
}
\arguments{
\item{eta}{A numeric vector input}

\item{lambda}{Tuning parameter (a single positive value)}

\item{p}{A probability vector (i.e., numeric vector of non-negative values that sum to one)}
}
\value{
Value of the softmax function or its inverse
}
\description{
\code{softmax} returns the value of the softmax function
\code{softmaxinv} returns the value of the inverse-softmax function
}
\details{
The softmax function is a bijective function that maps a real vector with length \code{m-1} to a probability vector
with length \code{m} with all non-zero probabilities.  The present functions define the softmax function and its inverse, both with a tuning
parameter.

The current functions define the softmax as:

\deqn{\Large P(\eta_i) = \frac{e^{\lambda \eta_i}}{1+ \sum_{j=1}^m e^{\lambda \eta_j}}}

Code adapted from the \href{https://github.com/ben-oneill/utilities/}{utilities} package
}
\examples{
softmax(5:7)
softmaxinv(softmax(5:7))
}
\keyword{transform}
