% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\docType{data}
\name{forest}
\alias{forest}
\title{forest Bayesian Network}
\format{
A discrete Bayesian network modelling the relationships between forest biodiversity, structure, and human health outcomes across 164 European forest stands. The full model was provided by the authors in a repository. The vertices are:
\describe{
\item{BasalArea}{(0 to 20, 20 to 90.3);}
\item{BirdBiophonyPerDay}{(Silence prevails, Intermediate, Biophony prevails);}
\item{BirdSpeciesDiversity}{(4 to 7, 7 to 9, 9 to 12);}
\item{CanopyRoughness}{(Low, Medium, High);}
\item{Condition}{(low, high);}
\item{CoolingCapacity}{(<-10, -10 to -5, -5 to 0, >= 0);}
\item{DecidousProportion}{(EvergreenOrMixed, DecidousDominated);}
\item{DeerAbundance}{(0 to 2, 2 to 4, 4 to 8);}
\item{DeltaPhysiologicalStress}{(Increase, Small decrease, Large decrease);}
\item{DeltaPhysStressControl}{(0.6 to 1.5);}
\item{DeltaPosAffControl}{(-35 to -8, -8 to 0, 0 to 8);}
\item{DeltaPositiveAffectA1}{(Decrease, Small increase, Large increase);}
\item{DominantCanopyHeight}{(0 to 20, 20 to 39);}
\item{DIN}{(0, 0 to 0.25, 0.25 to 1, >=1);}
\item{DON}{(0, 0 to 1, 1 to 3, 3 to 14.3);}
\item{DONCorrection}{(-0.5 to 0, 0 to 0.5);}
\item{EdibleMushroomProductivity}{(0 to 4, 4 to 40, 40 to 270);}
\item{ForestStandType}{(Mature and Natural, Young and Planted);}
\item{HeatMortalityForest}{(-5 to 0, 0 to 5, 5 to 10, >= 10);}
\item{HeatMortalityMacro}{(-5 to 0, 0 to 5, 5 to 10, >= 10);}
\item{HeatStressForest}{(None, Slight, Moderate, Strong, Extreme);}
\item{HeatStressMacro}{(Slight, Moderate, Strong, Extreme);}
\item{ImprovementAnxiety}{(Large, Small, Decline);}
\item{ImprovementNegativeAffect}{(Large, Small, Decline);}
\item{ImprovementPhysiologicalStress}{(Large, Small, Decline);}
\item{ImprovementPositiveAffect}{(Large, Small, Decline);}
\item{LeafAreaIndex}{(0 to 1, 1 to 3, 3 to 7.2);}
\item{LymeBorreliosisRisk}{(No risk, Low, Medium, High);}
\item{MeanLeafSize}{(0 to 1500, 1500 to 3000, 3000 to 10500);}
\item{MedicinalPlantDiversity}{(0 to 0.1, 0.1 to 0.24, 0.24 to 0.8);}
\item{MedicinalPlantProductivity}{(0 to 3.8, 3.8 to 15, 15 to 102);}
\item{MidFrequencyCoverBiophony}{(Little diverse, Intermediate, Highly diverse);}
\item{MortalityReduction}{(-5 to 0, 0 to 5, 5 to 10, >= 10);}
\item{MouseAbundance}{(0 to 10, 10 to 20, 20 to 30);}
\item{MushroomProductivity}{(0 to 10, 10 to 80, 80 to 400);}
\item{MushroomRelatedHealthBenefits}{(Low, Medium, High);}
\item{MushroomSpeciesDiversity}{(0 to 15, 15 to 30, 30 to 72);}
\item{NIP}{(0, 0 to 0.5, 0.5 to 1);}
\item{NIPCorrection}{(-1 to -0.75, -0.75 to -0.25, -0.25 to 0.25, 0.25 to 0.75, 0.75 to 1.05);}
\item{PerceivedAcousticDiversity}{(1 to 2, 2, 2 to 5);}
\item{PerceivedArtificialness}{(Low, Medium, High);}
\item{PerceivedBiodiversity}{(Low, Medium, High);}
\item{PerceivedDensity}{(Low, Medium, High);}
\item{PlotLevelPolyphenolContent}{(0 to 34, 34 to 600, 600 to 6000);}
\item{PM100Deposition}{(0 to 0.05, 0.05 to 0.15, 0.15 to 0.95);}
\item{PM10Deposition}{(0 to 0.035, 0.035 to 0.1, 0.1 to 0.35);}
\item{PM10InsideForest}{(4.77137 to 15, 15 to 20, 20 to 30);}
\item{PM10OutsideForest}{(10 to 15, 15 to 20, 20 to 30);}
\item{PM2.5Deposition}{(0 to 0.02, 0.02 to 0.07, 0.07 to 0.25);}
\item{PM2.5InsideForest}{(1.24706 to 7.5, 7.5 to 10, 10 to 15);}
\item{PM2.5OutsideForest}{(5 to 7.5, 7.5 to 10, 10 to 15);}
\item{PolyphenolRelatedHealthBenefits}{(Negligible, LowToMedium, High);}
\item{RelativeHumidity}{(0 to 80, 80 to 100);}
\item{RestorativenessA1}{(Low, Medium, High);}
\item{RestorativenessA2}{(Low, Medium, High);}
\item{RiskInsideForestPM10}{(1 to 1.05, 1.05 to 1.1, 1.1 to 1.15);}
\item{RiskInsideForestPM2.5}{(1 to 1.1, 1.1 to 1.15, 1.15 to 1.2);}
\item{RiskMitigationPM10}{(Low, Medium, High);}
\item{RiskMitigationPM2.5}{(1 to 1.05, 1.05 to 1.1, 1.1 to 1.15);}
\item{RiskOutsideForestPM10}{(1 to 1.05, 1.05 to 1.1, 1.1 to 1.15);}
\item{RiskOutsideForestPM2.5}{(1 to 1.1, 1.1 to 1.15, 1.15 to 1.2);}
\item{SoilFertility}{(Mull - fertile, Rich moder, Poor model or mor - infertile);}
\item{StemDensity}{(50 to 500, 500 to 2500, 2500 to 12200);}
\item{ThermalComfortForest}{(Cold, Cool, sCool, Neutral, sWarm, Warm);}
\item{ThermalComfortMacro}{(Cool, sCool, Neutral, sWarm, Warm, Hot);}
\item{ThermalPreferenceForest}{(Warmer, No Change, Colder);}
\item{ThermalPreferenceMacro}{(Warmer, No Change, Colder);}
\item{TreeSpeciesDiversity}{(Monospecific, Polyspecific);}
\item{UnderstoryProductivity}{(0 to 25, 25 to 75, 75 to 100);}
\item{VocalizingBirdSpeciesDiversity}{(4 to 10, 10 to 15, 15 to 25);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Forest biodiversity and structure modulate human health benefits and risks.
}
\references{
Gillerot, L., Landuyt, D., Bourdin, A., Rozario, K., Shaw, T., Steinparzer, M., ... & Verheyen, K. (2025). Forest biodiversity and structure modulate human health benefits and risks. Nature Sustainability, 1-13.
}
