% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_stan_code.R
\name{generate_stan_code_cat}
\alias{generate_stan_code_cat}
\title{Internal function to generate Stan Code for Neural Networks with Categorical Response}
\usage{
generate_stan_code_cat(num_layers, nodes)
}
\arguments{
\item{num_layers}{Integer. Number of layers in the neural network.}

\item{nodes}{Integer vector. Number of nodes in each layer. The length of
this vector must match \code{num_layers}, and all values must be positive.}
}
\value{
A string containing the Stan code for the specified neural network
architecture and categorical response model.
}
\description{
This function generates Stan code for modeling a categorical response using
neural networks with multiple layers. The generated code supports customizable
activation functions for each layer and softmax-based prediction for the categorical output.
}
\details{
The Stan code includes the following components:
\itemize{
\item \strong{Data Block}: Defines inputs, response variable, layer configurations, and activation functions.
\item \strong{Parameters Block}: Declares weights and biases for all layers and the output layer.
\item \strong{Transformed Parameters Block}: Computes intermediate outputs (\code{z} and \code{a}) for each layer
and calculates the final predictions (\code{y_hat}) using the softmax function.
\item \strong{Model Block}: Specifies priors for parameters and models the categorical response
using \code{categorical_logit}.
}

Supported activation functions for the hidden layers:
\itemize{
\item 1: Tanh
\item 2: Sigmoid
\item 3: Softplus
\item 4: ReLU
\item 5: linear
}

The categorical response (\code{y}) is assumed to take integer values from 1 to \code{K},
where \code{K} is the total number of categories.
}
\examples{
# Generate Stan code for a neural network with 3 layers
num_layers <- 3
nodes <- c(10, 8, 6) # 10 nodes in the first layer, 8 in the second, 6 in the third
stan_code <- generate_stan_code_cat(num_layers, nodes)
cat(stan_code)

}
\seealso{
\code{\link[=generate_stan_code_bin]{generate_stan_code_bin()}}, \code{\link[=generate_stan_code_cont]{generate_stan_code_cont()}}
}
\keyword{internal}
