% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_genotypes_admix.R
\name{draw_genotypes_admix}
\alias{draw_genotypes_admix}
\title{Draw genotypes from the admixture model}
\usage{
draw_genotypes_admix(p_ind, admix_proportions = NULL)
}
\arguments{
\item{p_ind}{The \code{m}-by-\code{n} IAF matrix (if \code{admix_proportions} is missing) or the \code{m}-by-\code{k} intermediate subpopulation allele frequency matrix (if \code{admix_proportions} is present).}

\item{admix_proportions}{The optional \code{n}-by-\code{k} admixture proportion matrix (to draw data from the admixture model using reduced memory, by not fully forming the IAF matrix).
If provided, and if both \code{admix_proportions} and \code{p_ind} have column names, and if they disagree, the function stops as a precaution, as this suggests the data is misaligned or inconsistent in some way.}
}
\value{
The \code{m}-by-\code{n} genotype matrix.
If \code{admix_proportions} is missing, the row and column names of \code{p_ind} are copied to this output.
If \code{admix_proportions} is present, the row names of the output are the row names of \code{p_ind}, while the column names of the output are the row names of \code{admix_proportions}.
}
\description{
Given the Individual-specific Allele Frequency (IAF) matrix \code{p_ind} for \code{m} loci (rows) and \code{n} individuals (columns), the genotype matrix \code{X} (same dimensions as \code{p_ind}) is drawn from the Binomial distribution equivalent to
\code{X[ i, j ] <- rbinom( 1, 2, p_ind[ i, j ] )},
except the function is more efficient.
If \code{admix_proportions} is provided as the second argument (a matrix with \code{n} individuals along rows and \code{k} intermediate subpopulations along the columns), the first argument \code{p_ind} is treated as the intermediate subpopulation allele frequency matrix (must be \code{m}-by-\code{k}) and the IAF matrix is equivalent to
\code{p_ind \%*\% t( admix_proportions )}.
However, in this case the function computes the IAF matrix in parts only, never stored in full, greatly reducing memory usage.
If \code{admix_proportions} is missing, then \code{p_ind} is treated as the IAF matrix.
}
\examples{
# dimensions
# number of loci
m_loci <- 10
# number of individuals
n_ind <- 5
# number of intermediate subpops
k_subpops <- 2

# define population structure
# FST values for k = 2 subpops
inbr_subpops <- c(0.1, 0.3)
# non-trivial admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)

# draw allele frequencies
# vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)

# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops(p_anc, inbr_subpops)

# matrix of individual-specific allele frequencies
p_ind <- make_p_ind_admix(p_subpops, admix_proportions)

# draw genotypes from intermediate subpops (one individual each)
X_subpops <- draw_genotypes_admix(p_subpops)

# and genotypes for admixed individuals
X_ind <- draw_genotypes_admix(p_ind)

# draw genotypes for admixed individuals without p_ind intermediate
# (p_ind is computed internally in parts, never stored in full,
# reducing memory use substantially)
X_ind <- draw_genotypes_admix(p_subpops, admix_proportions)

}
