% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.bolasso}
\alias{tidy.bolasso}
\title{Tidy a bolasso object}
\usage{
\method{tidy}{bolasso}(x, select = c("lambda.min", "lambda.1se", "min", "1se"), ...)
}
\arguments{
\item{x}{A \code{bolasso} object.}

\item{select}{One of "min", "1se", "lambda.min", "lambda.1se".
Both "min" and "lambda.min" are equivalent and are the lambda value
that minimizes cv MSE. Similarly "1se" and "lambda.1se" are equivalent
and refer to the lambda that achieves the most regularization and is
within 1se of the minimal cv MSE.}

\item{...}{Additional arguments to pass directly to \code{coef.bolasso}.}
}
\value{
A tidy \code{\link[tibble:tibble]{tibble::tibble()}} summarizing bootstrap-level
coefficients for each covariate.
}
\description{
Tidy a bolasso object
}
