\name{embb.sample}
\alias{embb.sample}

\title{EMBB Method}

\description{
The function constructs a bootstrap sample using the Extension of
Moving Block Bootstrap (EMBB) method or its circular version (CEMBB). 
The EMBB and  CEMBB are suitable for periodically
correlated and almost periodically correlated time series.
}

\usage{
	embb.sample(x,length.block,method=c("movingblock","circular"))
}

\arguments{
	\item{x}{An (almost) periodically correlated time series.}
	\item{length.block}{A positive integer; the number of bootstrap samples.}
	\item{method}{The bootstrap method:
	      * \code{"movingblock"} - EMBB,
	      * \code{"circular"} - CEMBB.}
}

\details{
The argument \code{method} can be set to \code{"movingblock"} (in the case
of the \code{EMBB}) or to \emph{"circular"} (in the case of \code{CEMBB}).
Method names may be abbreviated.
}

\value{
The \code{embb.sample} returns an object of type \code{embb} (not of type \code{boodd}),
containing a matrix whose first column is the bootstrapped
sample and second column contains the original time indices of the
chosen observations.
}


\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for 
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

A.E. Dudek (2015). Circular block bootstrap for coefficients of autocovariance function of almost periodically correlated time series, \emph{Metrika}, \bold{78},  313-335.

A.E. Dudek (2018).   Block bootstrap for periodic characteristics of periodically correlated
time series. \emph{Journal of Nonparametric Statistics}, \bold{30},  87-124.

}

\seealso{\code{\link{embb}},
\code{\link{seasonalMean}},\code{\link{seasonalVar}}, \code{\link{seasonalACF}},
\code{\link{meanCoeff}}, \code{\link{acfCoeff}}.}
\keyword{Block Bootstrap}
\keyword{Periodic time series}
\keyword{Almost periodically correlated time series}
\examples{
 # Generate a periodically correlated time series
 n=200
 b <- arima.sim(n = n, model = list(ar = c(0.5, 0.4), na = 0.5))
 period <- 12 
 x <- 5*cos(2 * pi /period * (1:n))+5*b * cos(2 * pi /period * (1:n))
 X_ts = ts(x)
 bootstrapped_X <- embb.sample(X_ts, length.block = 15, method = "movingblock")
}


