\name{seasonalMean, seasonalVar, seasonalACF }
\alias{seasonalMean}
\alias{seasonalVar}
\alias{seasonalACF}
\alias{seasonalMean.default}
\alias{seasonalVar.default}
\alias{seasonalACF.default}
\alias{seasonalMean.ts}
\alias{seasonalVar.ts}
\alias{seasonalACF.ts}

\title{Computes time domain characteristics of periodically correlated time series}

\description{
	Calculate estimates of the seasonal means, variances and
	autocovariances of a periodically correlated time series.
}

\usage{
	seasonalMean(x,period,\dots)
	seasonalVar(x,period,\dots)
	seasonalACF(x,tau,period,\dots)

\method{seasonalMean}{default}(x,period,\dots)
\method{seasonalVar}{default}(x,period,\dots)
\method{seasonalACF}{default}(x,tau,period,\dots)

\method{seasonalMean}{ts}(x,period=frequency(x),\dots)
\method{seasonalVar}{ts}(x,period=frequency(x),\dots)
\method{seasonalACF}{ts}(x,tau,period=frequency(x),\dots)
}

\arguments{
	\item{x}{A vector or time series representing a periodically correlated time series.}
	\item{period}{A positive integer; the period length. By default it is \code{frequency(x)}.}
	\item{tau}{A vector of integers; a single lag or vector of lags.}
	\item{\dots}{Optional additional arguments for the function.}
}

\details{
The functions \code{seasonalMean} and \code{seasonalVar} calculate
estimates of the seasonal means and variances respectively. The function
\code{seasonalACF} calculates an estimator of the autocovariance for the given
lags.

}

\value{
The \code{seasonalMean} and  \code{seasonalVar} functions return a vector of length \code{period}.

\code{seasonalACF} returns either a vector of length \code{period} if a single
lag \code{tau} is specified, or a matrix with \code{length(tau)} rows and \code{period}
columns if \code{tau} is a vector.
}


\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for 
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Hurd, H.L., Miamee, A.G. (2007). \emph{Periodically Correlated Random Sequences: Spectral. Theory and Practice}. Wiley.
}

\seealso{\code{\link{blockboot.seasonal}},
\code{\link{meanCoeff}}, \code{\link{acfCoeff}},
\code{\link{embb}},
\code{\link{embb.sample}},
\code{\link{bopt_circy}}.
}

\examples{
# Means
seasonalMean(nottem)  # The period is already in the time-series object nottem
# Variances
seasonalVar(nottem)
# Autocovariances
seasonalACF(nottem,c(0,1))
}

\keyword{Seasonal means}
\keyword{Seasonal variances}
\keyword{Seasonal autocovariances}
