% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smallEnsemble.R
\name{smallEnsemble}
\alias{smallEnsemble}
\title{Class \code{smallEnsemble}}
\usage{
smallEnsemble(s, eps, delta, trans)
}
\arguments{
\item{s}{A numeric value specifying the center of the small set.}

\item{eps}{A positive numeric value; the radius of the small set.}

\item{delta}{A positive numeric value; a lower bound for the transition density
over the small set,
controlling the Nummelin splitting trick.}

\item{trans}{A vector representing the estimated transition density between \eqn{X_i}
and \eqn{X_{i+1}}. This can be calculated using \code{\link{fastNadaraya}}.}
}
\value{
Returns an object of class \code{smallEnsemble}, containing the specified
parameters for the small set and the transition density.
}
\description{
Creates an object of class \code{smallEnsemble}, typically used in regenerative
bootstrap methods for Markov chains. This function allows manual specification
of parameters for the small ensemble.
}
\details{
The \code{smallEnsemble} object is used in regenerative bootstrap methods, particularly
in the context of Markov chains. It defines a small set, characterized by a central
point \code{s}, a radius \code{eps}, and a lower bound \code{delta}.

This function is useful for users who wish to manually specify the parameters
of the small set, as opposed to using automated methods like \code{findBestEpsilon},
which returns a \code{smallEnsemble} object.
}
\examples{
# Example of creating a smallEnsemble object
# Assuming a Markov chain data
data <- rnorm(100)
s <- median(data)   # Middle point of the small set
eps <- 0.5          # Width of the small set
delta <- 0.1        # Parameter of the small set
# Define a simple transition kernel function
trans <- fastNadaraya(data, 1/10)
# Create the smallEnsemble object
small_ensemble <- smallEnsemble(s, eps, delta, trans)

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P., Clémençon, S. (2006a). Regenerative Block
Bootstrap for Markov Chains. \emph{Bernoulli},  \bold{12}, 689-712.
}
\seealso{
\code{\link{regenboot}}, \code{\link{findBestEpsilon}}, \code{\link{fastNadaraya}}.
}
\keyword{"Bootstrap"}
\keyword{"Markov}
\keyword{"Regenerative"}
\keyword{chains"}
