% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockboot.seasonal.R
\name{blockboot.seasonal}
\alias{blockboot.seasonal}
\title{Generalized Seasonal Block Bootstrap for Time Series.}
\usage{
blockboot.seasonal(
  x,
  func,
  B,
  length.block = NULL,
  ...,
  method = c("GSBB", "CGSBB"),
  d
)
}
\arguments{
\item{x}{A vector or a time series.}

\item{func}{A function to apply to each sample.}

\item{B}{A positive integer; the number of bootstrap replications.}

\item{length.block}{A positive integer; the length of the blocks;
if \code{NULL}, a default value is used based on the time series period.
The default value is \code{d+1}.}

\item{...}{Optional additional arguments for the \code{func} function.}

\item{method}{The bootstrap method to use; can be \code{"GSBB"} for Generalized Seasonal
Block Bootstrap or \code{"CGSBB"} for Circular Generalized Seasonal Block Bootstrap.}

\item{d}{The length of the seasonal period in the time series.}
}
\value{
An object of class \code{boodd} containing the results of the bootstrap
procedure and the statistic computed by the \code{func} function on the original data.
}
\description{
Applies generalized block bootstrap methods, including the Generalized Seasonal Block
Bootstrap (GSBB) and the Circular Generalized Seasonal Block Bootstrap (CGSBB), to
periodically correlated (PC) processes in time series analysis.
}
\details{
This function is designed to handle the bootstrapping of time series data
that exhibit periodic correlation. It allows the use of two methods:
GSBB, which is based on moving blocks, and CGSBB, which uses a circular
approach. The function selects blocks of data with a specified length and
applies the user-defined function to each bootstrap sample. The user may calibrate
the optimal size of the blocks by using the \code{bopt_circy} function.

The function adapts to the seasonal structure of the data, making it suitable
for time series with inherent periodicity. The choice between GSBB and CGSBB
methods can be made according to the specific characteristics of the time series.
}
\examples{
set.seed(54321)
n <- 1000 # sample size
 f0 <- 1/12
 u <- rnorm(n, 0, 0.4)
 coeff=0.2
 b=rep(0,n)
 for (i in 2:(n-1)){ b[i+1]=coeff*b[i]+rnorm(1,0,0.4)}
 # Simulate a seasonal process with period 12
 X <- 5*cos(2 * pi * f0 * (1:n))+5*b * cos(2 * pi * f0 * (1:n)) + u
 X_ts <- ts(X)
 b=15 # Block length
 result = blockboot.seasonal(X_ts, mean, B=999, length.block=b, d=12, method="GSBB")
 plot(result, nclass=30)
 confint(result) 
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Patrice Bertail, Anna E. Dudek. (2022). Optimal choice of bootstrap block
length for periodically correlated time series. \emph{Bernoulli}, \bold{30}, 2521-2545.

Dudek, A.E., Leśkow, J., Paparoditis, E. and Politis, D. (2014a).
A generalized block bootstrap for seasonal time series. \emph{J. Time Ser. Anal.},
\bold{35}, 89-114.
}
\seealso{
\code{\link{blockboot}}, \code{\link{bopt_circy}}.
}
\keyword{"Bootstrap"}
\keyword{"Periodically}
\keyword{"Season"}
\keyword{correlated"}
