% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_PseudoBlocks.R
\name{f_PseudoBlocks}
\alias{f_PseudoBlocks}
\title{Compute the Value of the Function on a (Pseudo)-Regenerative Blocks.}
\usage{
f_PseudoBlocks(x, s, eps_opt, delta_opt, p_XiXip1, func = sum)
}
\arguments{
\item{x}{A vector or time series.}

\item{s}{A real number specifying the center of the small set.}

\item{eps_opt}{A numeric value for the size of the small set.}

\item{delta_opt}{A numeric value for the lower bound in the minorization condition.}

\item{p_XiXip1}{A numeric value representing the estimator of the transition density.}

\item{func}{A function to apply to each block. Default is \code{sum}.}
}
\value{
A matrix with two columns:
\itemize{
\item \code{Subf} - the value of the function \code{func} on each sub-block,
\item \code{lB} - the length of the sub-blocks on which the function is computed.
}
}
\description{
Function is an adaptation of \code{\link{GetPseudoBlocks}}
to compute the value of any function on pseudo-regenerative blocks.
}
\details{
This function computes the value of a specified function on pseudo-regenerative blocks
of a time series. It uses parameters such as the central value (\code{s}),
the size of the small set (\code{eps_opt}),
and the lower bound in the minorization condition (\code{delta_opt}).
Robustification is not proposed here
due to the complexity of the pseudo-regenerative procedure.
}
\examples{
\donttest{
n=1000 
coeff=0.75
X = arima.sim(n=n, list(ar = c(coeff)))
sm <- findBestEpsilon(X,s=0,plotIt=FALSE)
eps = sm$epsilon
delta = sm$delta
m = sm$s
f = sm$trans
result <- f_PseudoBlocks(X, 0, eps, delta, f, func = max)
print(result)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and Clémençon, S. (2006). Regenerative block bootstrap for Markov
chains. \emph{Bernoulli}, \bold{12}, 689-712.
}
\seealso{
\code{\link{GetPseudoBlocks}}, \code{\link{regenboot}}, \code{\link{findBestEpsilon}},
\code{\link{GetBlocks}}, \code{\link{smallEnsemble}}.
}
\keyword{"Optimal}
\keyword{"Pseudo-regenerative}
\keyword{"Regenerative}
\keyword{Block}
\keyword{Bootstrap"}
\keyword{blocks"}
\keyword{set"}
\keyword{small}
