% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuningModel.R
\name{bestMARSBoost}
\alias{bestMARSBoost}
\title{Tuning an MARSBoost model}
\usage{
bestMARSBoost(
  training,
  test,
  x,
  y,
  num.iterations,
  learning.rate,
  num.terms,
  verbose = TRUE
)
}
\arguments{
\item{training}{Training \code{data.frame} or \code{matrix} containing the
variables for model construction.}

\item{test}{Test \code{data.frame} or \code{matrix} containing the variables
for model assessment.}

\item{x}{Column input indexes in \code{training}.}

\item{y}{Column output indexes in \code{training}.}

\item{num.iterations}{Maximum number of iterations the algorithm will perform}

\item{learning.rate}{Learning rate that control overfitting of the algorithm.
Value must be in (0,1]}

\item{num.terms}{Maximum number of reflected pairs created by the forward
algorithm of MARS.}

\item{verbose}{Controls the verbosity.}
}
\value{
A \code{data.frame} with the sets of hyperparameters and the root
mean squared error (RMSE) associated for each model.
}
\description{
This funcion computes the root mean squared error (RMSE) for a
set of MARSBoost models built with a grid of given hyperparameters.
}
