% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PB_LRT.R
\name{PB_LRT}
\alias{PB_LRT}
\title{Parametric Bootstrap Likelihood Ratio Test (PB_LRT)}
\usage{
PB_LRT(means, vars, ns, tol = 1e-05, H = 1000, alpha = 0.05)
}
\arguments{
\item{means}{A numeric vector of group sample means.}

\item{vars}{A numeric vector of group sample variances.}

\item{ns}{A numeric vector of group sample sizes.}

\item{tol}{Convergence tolerance for iterative re-estimation under the null hypothesis. Default is 1e-5.}

\item{H}{Number of bootstrap iterations. Default is 1000.}

\item{alpha}{Significance level for the hypothesis test. Default is 0.05.}
}
\value{
A list of class \code{"PB_LRT"} containing:
\item{test_statistic}{Observed value of the likelihood ratio statistic.}
\item{critical_value}{Bootstrap-based critical value under the null hypothesis.}
\item{decision}{Conclusion of the hypothesis test.}
}
\description{
Performs a parametric bootstrap likelihood ratio test for comparing group means
under heteroscedasticity (unequal variances). This test serves as a robust alternative to classical one-way ANOVA
when the assumption of equal variances is violated.
}
\examples{
# Example with 3 groups
set.seed(123)
means <- c(5.1, 6.3, 7.0)
vars <- c(1.2, 1.8, 2.5)
ns <- c(20, 25, 22)
result <- PB_LRT(means, vars, ns)
print(result)

}
