% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RWPNPBT.R
\name{RWPNPBT}
\alias{RWPNPBT}
\title{Rademacher Wild Pairwise Non-Parametric Bootstrap Test (RWPNPBT)}
\usage{
RWPNPBT(group_list, B = 1e+05, alpha = 0.05)
}
\arguments{
\item{group_list}{A list where each element is a numeric vector of raw observations for a group.}

\item{B}{Number of bootstrap re-samples. Default is 100000.}

\item{alpha}{Significance level for the hypothesis test. Default is 0.05.}
}
\value{
A list of class \code{"RWPNPBT"} containing:
\item{test_statistic}{Observed value of the test statistic.}
\item{critical_value}{Bootstrap-based critical value at the given alpha level.}
\item{decision}{Conclusion of the hypothesis test based on the critical value.}
}
\description{
Performs a non-parametric bootstrap test using Rademacher wild bootstrap re-sampling.
This test compares all pairwise group means using a standardized distance metric,
making it robust to violations of normality and heteroscedasticity.
}
\details{
The test statistic sums the absolute standardized differences between all pairs of group means.
Rademacher weights are applied to centered observations for wild bootstrapping.
}
\examples{
set.seed(123)
group1 <- rexp(18, rate = 1/10)     # Exponential distribution
group2 <- runif(22, min = 10, max = 18)  # Uniform distribution
group3 <- rchisq(20, df = 5) + 7     # Right-skewed Chi-square + shift
RWPNPBT(list(group1, group2, group3), B = 1000)

}
