% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_of_integration.R
\name{diff_mult}
\alias{diff_mult}
\title{Differences of Multiple Time Series}
\usage{
diff_mult(data, d, keep_NAs = TRUE)
}
\arguments{
\item{data}{A (\eqn{T}x\eqn{N})-matrix of \eqn{N} time series with \eqn{T} observations. Data may also be in a time series format (e.g. \code{ts}, \code{zoo} or \code{xts}) or data frame.}

\item{d}{An \eqn{N}-dimensional vector containing the orders}

\item{keep_NAs}{Logical indicator whether or not to keep the \code{NA} values resulting from differencing at the beginning of the sample. Default is \code{TRUE}. If \code{FALSE}, the entire row containing the \code{NA} values is removed.}
}
\value{
The appropriately differenced data in the same format as the original data.
}
\description{
Performs differencing of multiple time series, with possibly different orders for each time series.
}
\references{
Smeekes, S. and Wilms, I. (2023). bootUR: An R Package for Bootstrap Unit Root Tests. \emph{Journal of Statistical Software}, 106(12), 1-39.
}
