% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braidModel.R
\name{invertBraidModel}
\alias{invertBraidModel}
\alias{invertBraidModel_A}
\alias{invertBraidModel_B}
\title{Invert a BRAID Response Surface Model}
\usage{
invertBraidModel(
  DA = NULL,
  DB = NULL,
  effect,
  bpar,
  invalidNA = FALSE,
  lowerBound = FALSE
)

invertBraidModel_A(DB, effect, bpar, invalidNA = FALSE, lowerBound = FALSE)

invertBraidModel_B(DA, effect, bpar, invalidNA = FALSE, lowerBound = FALSE)
}
\arguments{
\item{DA}{If not \code{NULL}, a vector of doses of drug A. Must be length 1 or
the same length as \code{effect}.  Only one of \code{DA} and \code{DB} may be not null.}

\item{DB}{If not \code{NULL}, a vector of doses of drug B. Must be length 1 or
the same length as \code{effect}.  Only one of \code{DA} and \code{DB} may be not null.}

\item{effect}{A vector of desired effect values to be reached.  Must be
length 1 or the same length as whichever of \code{DA} or \code{DB} is not null.}

\item{bpar}{A BRAID response surface parameter vector (see
\code{\link[=evalBraidModel]{evalBraidModel()}} for details)}

\item{invalidNA}{Specifies what to do with values that are outside the range
of the given BRAID model or doses.  If \code{FALSE} (the default), values "below"
the given range will be set to zero, and values "above" the given range will
be set to Inf.  If \code{TRUE}, all invalid values will be set to \code{NA}.}

\item{lowerBound}{Primarily used by \code{\link[=estimateIAE]{estimateIAE()}}.  If set to TRUE, will
return the lowest non-negative dose that produces an effect no greater than
the specified effect, rather than the highest}
}
\value{
A vector of concentrations the same length as either \code{DA} or \code{DB}
(whichever is not \code{NULL}) and/or \code{effect}, representing the concentration of
the other drug producing the specified effect in combination with the given
dose of the provided drug
}
\description{
Given a particular effect and one of the doses in a combined action response
surface, this function calculates the other dose that will produce the
desired effect.  Used in the estimation of the IAE (see \code{\link[=estimateIAE]{estimateIAE()}}) but
also useful for calculating something like the IC50 of one drug in the
presence of various doses of the other. \code{invertBraidModelA} and
\code{invertBraidModelB} are convenience wrapper functions that set \code{DA} or \code{DB}
to \code{NULL} to estimate the necessary concentrations of drug A and drug B
respectively.
}
\examples{
baseIC <- invertBraidModel_A(
    DB=0,
    effect=seq(10,90,by=10),
    bpar=c(1, 1, 3, 3, 2, 0, 100, 100, 100)
)

potentiatedIC <- invertBraidModel_A(
    DB=1,
    effect=seq(10,90,by=10),
    bpar=c(1, 1, 3, 3, 2, 0, 100, 100, 100)
)
}
