% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coeff_var}
\alias{coeff_var}
\alias{coeff_var.default}
\title{Calculate coefficient of variation}
\usage{
coeff_var(x, na.rm = FALSE, ...)

\method{coeff_var}{default}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector, matrix, or array}

\item{na.rm}{Logical indicating whether \code{NA} values should be stripped
when calculating sums. Default: \code{FALSE}}

\item{...}{Unused}
}
\value{
A numeric vector or matrix
}
\description{
\code{coeff_var} is a S3 generic that calculates the \emph{coefficient of
variation}, defined as
\deqn{CV(x) = \frac{sd(x)}{mean(x)}}
}
\details{
If \code{x} is a matrix, it will calculate the CV for each \emph{column}. If
\code{x} is a 3D array, it will calculate the coefficient of variation for
each \emph{row-column} combination. If the input dimensions are \eqn{n \times
n \times r}, a matrix with size \eqn{n \times n} will be returned.
}
