% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pSizeAtGen.R
\name{pSizeAtGen}
\alias{pSizeAtGen}
\title{Probability that n initial cases lead to an outbreak that lasts at least g generations
of transmission AND has exactly j total cases after generation g}
\usage{
pSizeAtGen(g, n, j, R, k)
}
\arguments{
\item{g}{Number of generations of transmission}

\item{n}{Number of initial cases}

\item{j}{Total size of outbreak after generation g}

\item{R}{Reproduction number: mean of negative binomial offspring distribution}

\item{k}{Dispersion parameter of negative binomial offspring distribution}
}
\value{
The probability of the given outbreak size at the given generation
}
\description{
Probability that n initial cases lead to an outbreak that lasts at least g generations
of transmission AND has exactly j total cases after generation g
}
\examples{
#Probability that 10 initial cases leads to an outbreak lasting at least
# 3 transmission generations and is of exact size 30 after 3 generations  
pSizeAtGen(g=3,n=10,j=30,R=2,k=0.5)
}
\author{
Damon Toth
}
