% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brand.R
\name{get_brand_color_mix}
\alias{get_brand_color_mix}
\title{Get a mix of brand colors}
\usage{
get_brand_color_mix(
  position = 500,
  color_1 = "primary",
  color_2 = "secondary",
  alpha = 0.5
)
}
\arguments{
\item{position}{(Optional) A \code{\link[base:numeric]{numeric}} vector indicating
the position of the brand color in the range of tints. The range of
positions is from \code{0} to \code{1000} (Default: \code{500}).}

\item{color_1, color_2}{(Optional) A \code{\link[base:character]{character}} string
indicating the name of a color present in the \code{color} section of the
\verb{_brand.yml} file (Default: \code{primary}, \code{secondary}).}

\item{alpha}{(Optional) A number between \code{0} and \code{1} indicating the alpha
(transparency) of the color mix (Default: \code{0.5}).}
}
\value{
A \code{\link[base:character]{character}} vector with
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal} color codes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{get_brand_color_mix()} mixes two specific brand colors.
}
\details{
\subsection{Path to \verb{_brand.yml}}{

\code{brandr} will always look for a \verb{_brand.yml} file in the root directory of
your project. If the file is not found, an error message will be displayed.
You can also set the path to the file manually using the
\code{\link[base:options]{options()}} function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(BRANDR_BRAND_YML = "PATH_TO_BRAND.YML")
}\if{html}{\out{</div>}}
}
}
\examples{
get_brand_color_mix(
  position = 500,
  color_1 = "primary",
  color_2 = "secondary",
  alpha = 0.5
)
#> [1] "#8A2C50" # Expected

get_brand_color_mix(
  position = c(250, 500, 750),
  color_1 = "primary",
  color_2 = "secondary",
  alpha = 0.25
)
#> [1] "#591E23" "#B23D46" "#D89EA2" # Expected
}
\seealso{
Other utility functions: 
\code{\link{get_brand_color}()},
\code{\link{get_brand_color_tint}()},
\code{\link{get_brand_font}()}
}
\concept{utility functions}
